/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.helper.ByteBufHelper;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;

public interface IChanceModifier {
    default public int getPriority() {
        return 0;
    }

    public String getDescription();

    default public void applyTooltip(List<String> currentTooltip) {
        currentTooltip.add(this.getDescription());
    }

    public double apply(double var1, @Nonnull World var3, @Nonnull List<ItemStack> var4, Entity var5, EntityLiving var6);

    default public void writeToByteBuf(ByteBuf byteBuf) {
    }

    default public void readFromByteBuf(ByteBuf byteBuf) {
    }

    public static void saveToByteBuf(ByteBuf byteBuf, IChanceModifier modifier) {
        String className = modifier.getClass().getName();
        ByteBufHelper.writeString(byteBuf, className);
        modifier.writeToByteBuf(byteBuf);
    }

    public static IChanceModifier loadFromByteBuf(ByteBuf byteBuf) {
        String className = ByteBufHelper.readString(byteBuf);
        try {
            Class<IChanceModifier> cl = Class.forName(className, false, null);
            if (!cl.isAssignableFrom(IChanceModifier.class)) {
                throw new SecurityException();
            }
            Constructor<?> constructor = cl.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            IChanceModifier modifier = (IChanceModifier)constructor.newInstance(new Object[0]);
            modifier.readFromByteBuf(byteBuf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static class PoweredCreeper
    implements IChanceModifier {
        @Override
        public String getDescription() {
            return Translations.POWERED_CREEPER.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (victim == null) {
                return 0.0;
            }
            if (victim instanceof EntityCreeper && ((EntityCreeper)victim).func_70830_n()) {
                return chance;
            }
            return 0.0;
        }
    }

    public static class EachLevelOfGives
    implements IChanceModifier {
        Enchantment enchantment;
        double change;

        protected EachLevelOfGives() {
        }

        public EachLevelOfGives(Enchantment enchantment, double change) {
            this.enchantment = enchantment;
            this.change = change;
        }

        @Override
        public String getDescription() {
            return Translations.EACH_LEVEL_OF_GIVES.get(StatCollector.func_74838_a((String)this.enchantment.func_77320_a()), this.change + "%");
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(attacker instanceof EntityPlayer)) {
                return chance;
            }
            ItemStack weapon = ((EntityPlayer)attacker).func_70694_bm();
            if (EnchantmentHelper.func_77506_a((int)this.enchantment.field_77352_x, (ItemStack)weapon) > 0) {
                return chance + this.change;
            }
            return chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeInt(this.enchantment.field_77352_x);
            byteBuf.writeDouble(this.change);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.enchantment = Enchantment.field_77331_b[byteBuf.readInt()];
            this.change = byteBuf.readDouble();
        }
    }

    public static class DropsOnlyInDimension
    implements IChanceModifier {
        int dimension;

        protected DropsOnlyInDimension() {
        }

        public DropsOnlyInDimension(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDescription() {
            return Translations.DROPS_ONLY_IN_DIMENSION.get(WorldProvider.func_76570_a((int)this.dimension).func_80007_l());
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (world.field_73011_w.field_76574_g == this.dimension) {
                return chance;
            }
            return 0.0;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeInt(this.dimension);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.dimension = byteBuf.readInt();
        }
    }

    public static class DropsOnlyWithEnchant
    implements IChanceModifier {
        EnchantmentData enchantmentData;

        protected DropsOnlyWithEnchant() {
        }

        public DropsOnlyWithEnchant(EnchantmentData enchantmentData) {
            this.enchantmentData = enchantmentData;
        }

        public DropsOnlyWithEnchant(Enchantment enchantment) {
            this.enchantmentData = new EnchantmentData(enchantment, 1);
        }

        public DropsOnlyWithEnchant(int enchantment) {
            this.enchantmentData = new EnchantmentData(enchantment, 1);
        }

        @Override
        public String getDescription() {
            return Translations.DROPS_ONLY_WITH_ENCHANT.get(StatCollector.func_74838_a((String)this.enchantmentData.field_76302_b.func_77320_a()));
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (!(attacker instanceof EntityPlayer)) {
                return 0.0;
            }
            ItemStack weapon = ((EntityPlayer)attacker).func_70694_bm();
            if (weapon == null) {
                return 0.0;
            }
            if (EnchantmentHelper.func_77506_a((int)this.enchantmentData.field_76302_b.field_77352_x, (ItemStack)weapon) >= this.enchantmentData.field_76303_c) {
                return chance;
            }
            return 0.0;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeInt(this.enchantmentData.field_76302_b.field_77352_x);
            byteBuf.writeInt(this.enchantmentData.field_76303_c);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.enchantmentData = new EnchantmentData(byteBuf.readInt(), byteBuf.readInt());
        }
    }

    public static class OrBiome
    implements IChanceModifier {
        BiomeGenBase biome;
        double newChance;

        protected OrBiome() {
        }

        public OrBiome(BiomeGenBase biome, double newChance) {
            this.biome = biome;
            this.newChance = newChance;
        }

        @Override
        public String getDescription() {
            return Translations.OR_BIOME.get(this.newChance, this.biome.field_76791_y);
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (victim == null) {
                return chance;
            }
            if (world.func_72807_a((int)victim.field_70165_t, (int)victim.field_70161_v) == this.biome) {
                return this.newChance;
            }
            return chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeInt(this.biome.field_76756_M);
            byteBuf.writeDouble(this.newChance);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.biome = BiomeGenBase.func_150568_d((int)byteBuf.readInt());
            this.newChance = byteBuf.readDouble();
        }
    }

    public static class OrUsing
    extends DropsOnlyUsing {
        double newChance;

        protected OrUsing() {
        }

        public OrUsing(ItemStack weapon, double newChance) {
            super(weapon);
            this.newChance = newChance;
        }

        public OrUsing(Item weapon, double newChance) {
            super(weapon);
            this.newChance = newChance;
        }

        @Override
        public String getDescription() {
            return Translations.OR_USING.get(this.newChance, this.weapon.func_82833_r());
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(attacker instanceof EntityPlayer)) {
                return 0.0;
            }
            ItemStack weapon = ((EntityPlayer)attacker).func_70694_bm();
            if (weapon == null) {
                return chance;
            }
            if (weapon.func_77973_b() == this.weapon.func_77973_b()) {
                return this.newChance;
            }
            return chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            super.writeToByteBuf(byteBuf);
            byteBuf.writeDouble(this.newChance);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            super.readFromByteBuf(byteBuf);
            this.newChance = byteBuf.readDouble();
        }
    }

    public static class DropsOnlyUsing
    implements IChanceModifier {
        ItemStack weapon;

        protected DropsOnlyUsing() {
        }

        public DropsOnlyUsing(ItemStack weapon) {
            this.weapon = weapon;
        }

        public DropsOnlyUsing(Item weapon) {
            this.weapon = new ItemStack(weapon);
        }

        @Override
        public String getDescription() {
            return Translations.DROPS_ONLY_USING.get(this.weapon.func_82833_r());
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (!(attacker instanceof EntityPlayer)) {
                return 0.0;
            }
            ItemStack weapon = ((EntityPlayer)attacker).func_70694_bm();
            if (weapon == null) {
                return 0.0;
            }
            if (weapon.func_77973_b() == this.weapon.func_77973_b()) {
                return chance;
            }
            return 0.0;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            new ConstructableItemStack(this.weapon).writeToByteBuf(byteBuf);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.weapon = ConstructableItemStack.readFromByteBuf(byteBuf).construct();
        }
    }

    public static class DropsOnlyWithWeaknessIII
    implements IChanceModifier {
        @Override
        public String getDescription() {
            return Translations.DROPS_ONLY_WITH_WEAKNESS_3.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (victim == null) {
                return 0.0;
            }
            if (victim.func_70644_a(Potion.field_76437_t) && victim.func_70660_b(Potion.field_76437_t).func_76458_c() >= 2) {
                return chance;
            }
            return 0.0;
        }
    }

    public static class BaseChance
    extends NormalChance {
        protected BaseChance() {
        }

        public BaseChance(double chance) {
            super(chance);
        }

        @Override
        public String getDescription() {
            return Translations.BASE_CHANCE.get(this.chance);
        }
    }

    public static class NormalChance
    implements IChanceModifier {
        double chance;

        protected NormalChance() {
        }

        public NormalChance(double chance) {
            this.chance = chance;
        }

        @Override
        public int getPriority() {
            return 999999;
        }

        @Override
        public String getDescription() {
            return Translations.CHANCE.get(this.chance);
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return this.chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeDouble(this.chance);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.chance = byteBuf.readDouble();
        }
    }
}

