/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.helper.TranslationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;

public class SpawnInfo {
    private static final HashSet<SpawnInfo> allKnownInfos = new HashSet();
    protected final String info;

    public static Set<SpawnInfo> getAllKnownInfos() {
        return allKnownInfos;
    }

    public SpawnInfo() {
        this.info = null;
        if (this.getClass() == SpawnInfo.class) {
            throw new UnsupportedOperationException();
        }
    }

    public SpawnInfo(String info) {
        this.info = info;
        allKnownInfos.add(this);
    }

    public String getInfo() {
        return this.info;
    }

    public int hashCode() {
        return this.getInfo().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpawnInfo)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public static class SpawnInfoEvent
    extends SpawnInfo {
        private final String eventInfo;

        public SpawnInfoEvent(String eventInfo) {
            this.eventInfo = eventInfo;
        }

        @Override
        public String getInfo() {
            return Translations.EVENT.get() + this.eventInfo;
        }
    }

    public static class SpawnInfoStructure
    extends SpawnInfo {
        private final String structureName;

        public SpawnInfoStructure(String structureName) {
            this.structureName = structureName;
            allKnownInfos.add(this);
        }

        @Override
        public String getInfo() {
            return Translations.STRUCTURE.get() + this.structureName;
        }
    }

    public static class SpawnInfoBiome
    extends SpawnInfo {
        private final BiomeGenBase biome;

        public SpawnInfoBiome(BiomeGenBase biome) {
            this.biome = biome;
            allKnownInfos.add(this);
        }

        @Override
        public String getInfo() {
            return Translations.BIOME.get() + this.biome.field_76791_y;
        }

        public BiomeGenBase getBiome() {
            return this.biome;
        }
    }

    static enum Translations {
        BIOME,
        STRUCTURE,
        EVENT;

        final String key = "mobsinfo.spawninfo." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public List<String> getAllLines() {
            ArrayList<String> lines = new ArrayList<String>(Collections.singletonList(StatCollector.func_74838_a((String)this.key)));
            int i = 1;
            while (StatCollector.func_94522_b((String)(this.key + "_" + i))) {
                lines.add(StatCollector.func_74838_a((String)(this.key + "_" + i++)));
            }
            return lines;
        }

        public String get(Object ... args) {
            return TranslationHelper.translateFormattedFixed(this.key, args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

