/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Size;

public class RepeatingDrawable
implements IDrawable {
    private IDrawable drawable;
    private Size drawableSize;
    private int spaceX;
    private int spaceY;

    public RepeatingDrawable setDrawable(IDrawable drawable) {
        this.drawable = drawable;
        return this;
    }

    public RepeatingDrawable setDrawableSize(Size size) {
        this.drawableSize = size;
        return this;
    }

    public RepeatingDrawable setDrawableSize(int width, int height) {
        return this.setDrawableSize(new Size(width, height));
    }

    public RepeatingDrawable setSpaceX(int spaceX) {
        this.spaceX = spaceX;
        return this;
    }

    public RepeatingDrawable setSpaceY(int spaceY) {
        this.spaceY = spaceY;
        return this;
    }

    @Override
    public void applyThemeColor(int color) {
        if (this.drawable != null) {
            this.drawable.applyThemeColor(color);
        }
    }

    @Override
    public void draw(float x0, float y0, float width, float height, float partialTicks) {
        if (this.drawable == null) {
            return;
        }
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (this.drawableSize.width <= 0 || this.drawableSize.height <= 0) {
            return;
        }
        double[] translation = GlStateManager.getTranslation();
        GuiHelper.useScissor((int)((double)x0 + translation[0]), (int)((double)y0 + translation[1]), (int)width, (int)height, () -> {
            float x = x0;
            float x1 = x0 + width;
            float y1 = y0 + height;
            for (float y = y0; y < y1; y += (float)(this.drawableSize.height + this.spaceY)) {
                while (x < x1) {
                    this.drawable.draw(x, y, this.drawableSize.width, this.drawableSize.height, partialTicks);
                    x += (float)(this.drawableSize.width + this.spaceX);
                }
                x = x0;
            }
        });
    }
}

