/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.math;

import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import java.awt.Rectangle;
import java.util.Objects;

public final class GuiArea {
    public final int x0;
    public final int x1;
    public final int y0;
    public final int y1;
    public final int width;
    public final int height;

    public GuiArea(int x0, int x1, int y0, int y1) {
        this.x0 = Math.min(x0, x1);
        this.x1 = Math.max(x0, x1);
        this.y0 = Math.min(y0, y1);
        this.y1 = Math.max(y0, y1);
        this.width = this.x1 - this.x0;
        this.height = this.y1 - this.y0;
    }

    public static GuiArea ofRectangle(Rectangle rectangle) {
        return GuiArea.ltwh(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static GuiArea ofPoints(Pos2d p0, Pos2d p1) {
        return new GuiArea(p0.x, p1.x, p0.y, p1.y);
    }

    public static GuiArea of(Size size, Pos2d pos) {
        return GuiArea.ltwh(pos.x, pos.y, size.width, size.height);
    }

    public static GuiArea ltwh(int x, int y, int width, int height) {
        return new GuiArea(x, x + width, y, y + height);
    }

    public GuiArea withSize(int width, int height) {
        return new GuiArea(this.x0, this.x0 + width, this.y0, this.y0 + height);
    }

    public GuiArea withSize(Size size) {
        return this.withSize(size.width, this.height);
    }

    public GuiArea withPos(int x, int y) {
        return new GuiArea(x, x + this.width, y, y + this.height);
    }

    public GuiArea translate(int x, int y) {
        return new GuiArea(this.x0 + x, this.x1 + x, this.y0 + y, this.y1 + y);
    }

    public GuiArea scale(float scale, float xPivot, float yPivot) {
        return this.scale(scale, scale, xPivot, yPivot);
    }

    public GuiArea scale(float xScale, float yScale, float xPivot, float yPivot) {
        int x0 = this.x0;
        int x1 = this.x1;
        int y0 = this.y0;
        int y1 = this.y1;
        x0 = (int)(xPivot - (xPivot - (float)x0) * xScale);
        y0 = (int)(yPivot - (yPivot - (float)y0) * yScale);
        x1 = (int)(xPivot + ((float)x1 - xPivot) * xScale);
        y1 = (int)(yPivot + ((float)y1 - yPivot) * yScale);
        return new GuiArea(x0, x1, y0, y1);
    }

    public boolean contains(float x, float y) {
        return x >= (float)this.x0 && x <= (float)this.x1 && y >= (float)this.y0 && y <= (float)this.y1;
    }

    public boolean contains(Pos2d pos) {
        return this.contains(pos.getX(), pos.getY());
    }

    public boolean intersects(GuiArea bounds) {
        for (Alignment alignment : Alignment.CORNERS) {
            if (!this.contains(bounds.corner(alignment))) continue;
            return true;
        }
        return false;
    }

    public boolean covers(GuiArea bounds) {
        for (Alignment alignment : Alignment.CORNERS) {
            if (this.contains(bounds.corner(alignment))) continue;
            return false;
        }
        return true;
    }

    public Pos2d getCenter() {
        return new Pos2d((this.x1 - this.x0) / 2 + this.x0, (this.y1 - this.y0) / 2 + this.y0);
    }

    public Pos2d getTopLeft() {
        return new Pos2d(this.x0, this.y0);
    }

    public Pos2d corner(Alignment alignment) {
        Pos2d center = this.getCenter();
        int x = (int)(center.getX() + (float)(this.width / 2 * alignment.x));
        int y = (int)(center.getY() + (float)(this.height / 2 * alignment.y));
        return new Pos2d(x, y);
    }

    public float getArea() {
        return this.width * this.height;
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiArea GuiArea2 = (GuiArea)o;
        return GuiArea2.x0 == this.x0 && GuiArea2.x1 == this.x1 && GuiArea2.y0 == this.y0 && GuiArea2.y1 == this.y1;
    }

    public int hashCode() {
        return Objects.hash(this.x0, this.x1, this.y0, this.y1);
    }

    public String toString() {
        return "Size:[" + this.width + ", " + this.height + "], Pos:[" + this.x0 + ", " + this.y0 + "]";
    }

    public Rectangle asRectangle() {
        return new Rectangle(this.x0, this.y0, this.width, this.height);
    }
}

