/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.widget.Widget;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableWidget
extends Widget {
    @NotNull
    private Supplier<IDrawable> drawable = () -> IDrawable.EMPTY;

    @Override
    public void readJson(JsonObject json, String type) {
        super.readJson(json, type);
        if (type.equals("image")) {
            this.setDrawable(UITexture.ofJson(json));
        }
    }

    @Override
    public void onScreenUpdate() {
        if (this.drawable.get() != null) {
            this.drawable.get().tick();
        }
    }

    @Override
    public void draw(float partialTicks) {
        if (this.drawable.get() != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translate(0.0f, 0.0f, 150 * this.getWindowLayer());
            this.drawable.get().draw(Pos2d.ZERO, this.getSize(), partialTicks);
            GlStateManager.popMatrix();
        }
    }

    @Nullable
    public IDrawable getDrawable() {
        return this.drawable.get();
    }

    public DrawableWidget setDrawable(@Nullable IDrawable drawable) {
        if (drawable instanceof Text) {
            ModularUI.logger.warn("Please use TextWidget for Text");
        }
        this.drawable = () -> drawable;
        return this;
    }

    public DrawableWidget setDrawable(@NotNull Supplier<IDrawable> drawable) {
        this.drawable = drawable;
        return this;
    }
}

