/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ExpandTab;
import com.gtnewhorizons.modularui.common.widget.ListWidget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.network.PacketBuffer;

public class DropDownWidget
extends ExpandTab
implements ISyncedWidget {
    private final ListWidget listContainer;
    private final DrawableWidget selectedWidget;
    private final DrawableWidget arrowWidget;
    private Direction direction = Direction.DOWN;
    private int expandedMaxHeight = 60;
    private final List<IDrawable> labels = new ArrayList<IDrawable>();
    private int selected = -1;
    private IDrawable textUnselected = Text.localised("modularui.dropdown.select", new Object[0]).withOffset(0.0f, 1.0f);
    private boolean syncsToServer = true;
    private boolean syncsToClient = true;
    private boolean needsUpdate;
    private static final IDrawable TEXTURE_ARROW_UP = ModularUITextures.ARROW_GRAY_UP.withFixedSize(10.0f, 10.0f);
    private static final IDrawable TEXTURE_ARROW_DOWN = ModularUITextures.ARROW_GRAY_DOWN.withFixedSize(10.0f, 10.0f);

    public DropDownWidget() {
        this.setAnimateDuration(150);
        this.setSize(60, 10);
        this.setBackground(ModularUITextures.BACKGROUND_BORDER_1PX);
        this.listContainer = new ListWidget();
        this.addChild(this.listContainer.setMaxHeight(this.expandedMaxHeight).setPosProvider((screenSize, window, parent) -> new Pos2d(0, this.direction == Direction.DOWN ? this.normalSize.height : 0)));
        this.selectedWidget = new DrawableWidget();
        this.addChild(this.selectedWidget.setDrawable(() -> {
            if (this.selected > -1 && this.selected < this.labels.size()) {
                return this.labels.get(this.selected);
            }
            return this.textUnselected;
        }).setSizeProvider((screenSize, window, parent) -> this.normalSize).setPosProvider((screenSize, window, parent) -> new Pos2d(0, this.direction == Direction.UP && this.isExpanded() ? this.getActualExpandedHeight() : 0)));
        this.arrowWidget = new DrawableWidget();
        this.addChild(this.arrowWidget.setDrawable(() -> this.getArrowTexture(this.isExpanded())).setSize(10, 10).setPosProvider((screenSize, window, parent) -> new Pos2d(this.getSize().width - 10, this.direction == Direction.UP && this.isExpanded() ? this.getActualExpandedHeight() : 0)));
    }

    @Override
    public void onRebuild() {
        super.onRebuild();
        this.setExpandedSizeAndPos();
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        Interactable.ClickResult clickResult = super.onClick(buttonId, doubleClick);
        if (clickResult == Interactable.ClickResult.ACCEPT) {
            Interactable.playButtonClickSound();
        }
        return clickResult;
    }

    @Override
    public boolean shouldDrawChildWidgetWhenCollapsed(Widget child) {
        return child == this.selectedWidget || child == this.arrowWidget;
    }

    protected int getActualExpandedHeight() {
        return Math.min(this.expandedMaxHeight, this.getChildrenHeight());
    }

    protected void setExpandedSizeAndPos() {
        int expandedHeight = this.getActualExpandedHeight();
        switch (this.direction) {
            case UP: {
                this.expandedSize = this.normalSize.grow(0, expandedHeight);
                this.expandedPos = this.normalPos.add(0, -expandedHeight);
                break;
            }
            case DOWN: {
                this.expandedSize = this.normalSize.grow(0, expandedHeight);
            }
        }
    }

    protected int getChildrenHeight() {
        int totalHeight = 0;
        for (Widget child : this.listContainer.getUnnestedChildren()) {
            totalHeight += child.getSize().height;
        }
        return totalHeight;
    }

    protected IDrawable getArrowTexture(boolean flipped) {
        if (flipped) {
            switch (this.direction) {
                case UP: {
                    return TEXTURE_ARROW_DOWN;
                }
                case DOWN: {
                    return TEXTURE_ARROW_UP;
                }
            }
            throw new RuntimeException("Unknown direction: " + (Object)((Object)this.direction));
        }
        switch (this.direction) {
            case UP: {
                return TEXTURE_ARROW_UP;
            }
            case DOWN: {
                return TEXTURE_ARROW_DOWN;
            }
        }
        throw new RuntimeException("Unknown direction: " + (Object)((Object)this.direction));
    }

    public DropDownWidget addDropDownItem(IDrawable label, Widget widget) {
        this.labels.add(label);
        this.listContainer.addChild(widget);
        return this;
    }

    public DropDownWidget addDropDownItem(String label, Widget widget) {
        return this.addDropDownItem(new Text(label).withOffset(0.0f, 1.0f), widget);
    }

    public DropDownWidget addDropDownItems(List<String> labels, List<Widget> widgets) {
        assert (labels.size() == widgets.size());
        for (int i = 0; i < labels.size(); ++i) {
            this.addDropDownItem(labels.get(i), widgets.get(i));
        }
        return this;
    }

    public DropDownWidget addDropDownItems(List<String> labels, BiFunction<Integer, String, Widget> widgetCreator) {
        for (int i = 0; i < labels.size(); ++i) {
            this.addDropDownItem(labels.get(i), widgetCreator.apply(i, labels.get(i)));
        }
        return this;
    }

    public DropDownWidget addDropDownItemsSimple(List<String> labels, ApplyForEachButton applyForEachButton, boolean collapseOnSelect) {
        return this.addDropDownItems(labels, (Integer index, String label) -> {
            IDrawable text = new Text((String)label).withOffset(0.0f, 1.0f);
            ButtonWidget buttonWidget = new ButtonWidget();
            buttonWidget.setHoveredBackground(new Rectangle().setColor(Color.LIGHT_BLUE.bright(2)), text).setBackground(text).setSizeProvider((screenSize, window, parent) -> this.normalSize);
            applyForEachButton.apply(buttonWidget, (int)index, (String)label, () -> {
                this.setSelected((int)index);
                if (collapseOnSelect) {
                    this.setExpanded(false);
                }
            });
            return buttonWidget;
        });
    }

    public int getSelected() {
        return this.selected;
    }

    public List<IDrawable> getLabels() {
        return this.labels;
    }

    public ListWidget getListContainer() {
        return this.listContainer;
    }

    public boolean syncsToClient() {
        return this.syncsToClient;
    }

    public boolean syncsToServer() {
        return this.syncsToServer;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.setSelected(buf.func_150792_a(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.setSelected(buf.func_150792_a(), false);
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (this.syncsToClient() && init) {
            this.setSelected(this.selected, true);
            this.markForUpdate();
        }
    }

    public DropDownWidget setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public DropDownWidget setExpandedMaxHeight(int expandedMaxHeight) {
        this.expandedMaxHeight = expandedMaxHeight;
        this.listContainer.setMaxHeight(expandedMaxHeight);
        return this;
    }

    public DropDownWidget setSelected(int selected) {
        return this.setSelected(selected, false);
    }

    public DropDownWidget setSelected(int selected, boolean sync) {
        this.selected = selected;
        if (sync) {
            if (this.isClient()) {
                if (this.syncsToServer()) {
                    this.syncToServer(1, buffer -> buffer.func_150787_b(selected));
                }
            } else if (this.syncsToClient()) {
                this.syncToClient(1, buffer -> buffer.func_150787_b(selected));
            }
        }
        return this;
    }

    public DropDownWidget setTextUnselected(IDrawable textUnselected) {
        this.textUnselected = textUnselected;
        return this;
    }

    public DropDownWidget setTextUnselected(String textUnselected) {
        return this.setTextUnselected(new Text(textUnselected).withOffset(0.0f, 1.0f));
    }

    public DropDownWidget setLabel(int index, IDrawable label) {
        this.labels.set(index, label);
        Widget child = (Widget)this.listContainer.children.get(index);
        child.setBackground(label);
        if (child instanceof ButtonWidget) {
            ((ButtonWidget)child).setHoveredBackground(new Rectangle().setColor(Color.LIGHT_BLUE.bright(2)), label);
        }
        return this;
    }

    public DropDownWidget setLabel(int index, String label) {
        return this.setLabel(index, new Text(label));
    }

    public DropDownWidget setSynced(boolean syncsToClient, boolean syncsToServer) {
        this.syncsToClient = syncsToClient;
        this.syncsToServer = syncsToServer;
        return this;
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    @FunctionalInterface
    public static interface ApplyForEachButton {
        public void apply(ButtonWidget var1, int var2, String var3, Runnable var4);
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

