/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEISettingsImpl;
import com.cleanroommc.modularui.screen.UISettings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class ClientGUI {
    private ClientGUI() {
    }

    public static void open(@NotNull ModularScreen screen) {
        ClientGUI.open(screen, new UISettings());
    }

    public static void open(@NotNull ModularScreen screen, @NotNull NEISettingsImpl neiSettings) {
        GuiManager.openScreen(screen, new UISettings(neiSettings));
    }

    public static void open(@NotNull ModularScreen screen, @Nullable Supplier<ModularContainer> container) {
        UISettings settings = new UISettings();
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull NEISettingsImpl neiSettings, @Nullable Supplier<ModularContainer> container) {
        UISettings settings = new UISettings(neiSettings);
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull UISettings settings) {
        GuiManager.openScreen(screen, settings);
    }

    public static void open(GuiScreen screen) {
        MCHelper.displayScreen(screen);
    }

    public static void close() {
        MCHelper.displayScreen(null);
    }
}

