/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.overlay;

import com.cleanroommc.modularui.overlay.OverlayHandler;
import com.cleanroommc.modularui.overlay.OverlayStack;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class OverlayManager {
    public static final List<OverlayHandler> overlays = new ArrayList<OverlayHandler>();

    public static void register(OverlayHandler handler) {
        if (!overlays.contains(handler)) {
            overlays.add(handler);
            overlays.sort(OverlayHandler::compareTo);
        }
    }

    public static void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != Minecraft.func_71410_x().field_71462_r) {
            OverlayStack.closeAll();
            if (event.gui == null) {
                return;
            }
            for (OverlayHandler handler : overlays) {
                if (!handler.isValidFor(event.gui)) continue;
                ModularScreen overlay = Objects.requireNonNull(handler.createOverlay(event.gui), "Overlays must not be null!");
                overlay.constructOverlay(event.gui);
                OverlayStack.open(overlay);
            }
        }
    }
}

