/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.NEISettings;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.integration.nei.NEIState;
import com.cleanroommc.modularui.screen.ModularScreen;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnmodifiableView;

@SideOnly(value=Side.CLIENT)
public class NEISettingsImpl
implements NEISettings {
    private NEIState neiState = NEIState.DEFAULT;
    private final List<IWidget> neiExclusionWidgets = new ArrayList<IWidget>();
    private final List<Rectangle> neiExclusionAreas = new ArrayList<Rectangle>();

    @Override
    public void enableNEI() {
        this.neiState = NEIState.ENABLED;
    }

    @Override
    public void disableNEI() {
        this.neiState = NEIState.DISABLED;
    }

    @Override
    public void defaultNEI() {
        this.neiState = NEIState.DEFAULT;
    }

    @Override
    public boolean isNEIEnabled(ModularScreen screen) {
        return ModularUI.Mods.NEI.isLoaded() && this.neiState.test(screen);
    }

    @Override
    public void addNEIExclusionArea(Rectangle area) {
        if (!this.neiExclusionAreas.contains(area)) {
            this.neiExclusionAreas.add(area);
        }
    }

    @Override
    public void removeNEIExclusionArea(Rectangle area) {
        this.neiExclusionAreas.remove(area);
    }

    @Override
    public void addNEIExclusionArea(IWidget area) {
        if (!this.neiExclusionWidgets.contains(area)) {
            this.neiExclusionWidgets.add(area);
        }
    }

    @Override
    public void removeNEIExclusionArea(IWidget area) {
        this.neiExclusionWidgets.remove(area);
    }

    public @UnmodifiableView List<Rectangle> getNEIExclusionAreas() {
        return Collections.unmodifiableList(this.neiExclusionAreas);
    }

    public @UnmodifiableView List<IWidget> getNEIExclusionWidgets() {
        return Collections.unmodifiableList(this.neiExclusionWidgets);
    }

    @ApiStatus.Internal
    public List<Rectangle> getAllNEIExclusionAreas() {
        this.neiExclusionWidgets.removeIf(widget -> !widget.isValid());
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.neiExclusionAreas);
        Iterator<IWidget> iterator = this.neiExclusionWidgets.iterator();
        while (iterator.hasNext()) {
            IWidget widget2 = iterator.next();
            if (!widget2.isValid()) {
                iterator.remove();
                continue;
            }
            if (!widget2.isEnabled()) continue;
            areas.add(widget2.getArea());
        }
        return areas;
    }
}

