/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser;

import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Argument;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.CloneCache;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Expression;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.PrimitiveElement;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.SerializationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RecursiveArgument
extends Argument
implements Serializable {
    private static final int serialClassID = 4;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(4);
    public static final int TYPE_ID_RECURSIVE = 102;
    public static String TYPE_DESC_RECURSIVE = "<NA>";
    private List<Double> baseValues = null;
    private int recursiveCounter = -1;
    private int startingIndex = 0;

    private void initRecursiveArgument() {
        this.argumentType = 3;
        this.baseValues = new ArrayList<Double>();
        this.recursiveCounter = -1;
        this.argumentExpression.addArguments(this.n);
        this.argumentExpression.addArguments(this);
    }

    private void initRecursiveArgument(PrimitiveElement ... elements) {
        this.initRecursiveArgument();
        this.argumentExpression.addDefinitions(elements);
    }

    public RecursiveArgument(String argumentName, String recursiveExpressionString, String indexName) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (!this.syntaxStatusDefinition) {
            return;
        }
        this.n = new Argument(indexName, new PrimitiveElement[0]);
        this.initRecursiveArgument();
    }

    public RecursiveArgument(String argumentName, String recursiveExpressionString, Argument n, PrimitiveElement ... elements) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (!this.syntaxStatusDefinition) {
            return;
        }
        this.n = n;
        this.initRecursiveArgument(elements);
    }

    public RecursiveArgument(String argumentDefinitionString, PrimitiveElement ... elements) {
        super(true, argumentDefinitionString, new PrimitiveElement[0]);
        if (!this.syntaxStatusDefinition) {
            return;
        }
        this.initRecursiveArgument(elements);
    }

    private RecursiveArgument(RecursiveArgument recursiveArgumentToClone, CloneCache cloneCache) {
        super(recursiveArgumentToClone, true, cloneCache);
        this.baseValues = new ArrayList<Double>();
        this.baseValues.addAll(recursiveArgumentToClone.baseValues);
        this.recursiveCounter = recursiveArgumentToClone.recursiveCounter;
        this.startingIndex = recursiveArgumentToClone.startingIndex;
    }

    public void addBaseCase(int index, double value) {
        int recSize = this.baseValues.size();
        if (index < recSize) {
            this.baseValues.set(index, value);
            return;
        }
        for (int i = recSize; i < index; ++i) {
            this.baseValues.add(Double.NaN);
        }
        this.baseValues.add(value);
    }

    public void resetAllCases() {
        this.baseValues.clear();
        this.recursiveCounter = -1;
    }

    public double getArgumentValue(double index) {
        if (this.recursiveCounter == -1) {
            this.startingIndex = (int)Math.round(index);
        }
        int recSize = this.baseValues.size();
        int idx = (int)Math.round(index);
        ++this.recursiveCounter;
        if (this.recursiveCounter > this.startingIndex || idx > this.startingIndex) {
            --this.recursiveCounter;
            return Double.NaN;
        }
        if (idx >= 0 && idx < recSize && !Double.isNaN(this.baseValues.get(idx))) {
            --this.recursiveCounter;
            return this.baseValues.get(idx);
        }
        if (idx < 0) {
            --this.recursiveCounter;
            return Double.NaN;
        }
        if (this.n == null) {
            --this.recursiveCounter;
            return Double.NaN;
        }
        this.n.setArgumentValue(idx);
        Expression newExp = new Expression(this.argumentExpression.expressionString, this.argumentExpression.argumentsList, this.argumentExpression.functionsList, this.argumentExpression.constantsList, true, this.argumentExpression.UDFExpression, this.argumentExpression.UDFVariadicParamsAtRunTime);
        newExp.setDescription(super.getArgumentName());
        if (super.getVerboseMode()) {
            newExp.setVerboseMode();
        }
        double value = newExp.calculate();
        this.addBaseCase(idx, value);
        --this.recursiveCounter;
        return value;
    }

    @Override
    RecursiveArgument cloneForThreadSafeInternal(CloneCache cloneCache) {
        RecursiveArgument recursiveArgumentClone = (RecursiveArgument)cloneCache.getArgumentClone(this);
        if (recursiveArgumentClone == null) {
            cloneCache.cacheCloneInProgress(this);
            recursiveArgumentClone = new RecursiveArgument(this, cloneCache);
            cloneCache.clearCloneInProgress(this);
            cloneCache.cacheArgumentClone(this, recursiveArgumentClone);
        }
        return recursiveArgumentClone;
    }

    @Override
    RecursiveArgument cloneForThreadSafeInternal(Expression relatedExpressionThatInitiatedClone, CloneCache cloneCache) {
        RecursiveArgument recursiveArgumentClone = this.cloneForThreadSafeInternal(cloneCache);
        recursiveArgumentClone.addRelatedExpression(relatedExpressionThatInitiatedClone);
        return recursiveArgumentClone;
    }

    @Override
    public RecursiveArgument cloneForThreadSafe() {
        CloneCache cloneCache = new CloneCache();
        RecursiveArgument recursiveArgumentClone = this.cloneForThreadSafeInternal(cloneCache);
        cloneCache.addAllAtTheEndElements();
        cloneCache.clearCache();
        return recursiveArgumentClone;
    }
}

