/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonObject;

public class WidgetSlotTheme
extends WidgetTheme {
    private final int slotHoverColor;
    private final boolean useCustomSlotTextures;
    private final IDrawable inventorySlotBackground;
    private final IDrawable hotbarSlotBackground;

    public WidgetSlotTheme(IDrawable background, int slotHoverColor) {
        this(background, slotHoverColor, false, null, null);
    }

    public WidgetSlotTheme(IDrawable background, int slotHoverColor, boolean useCustomSlotTextures, IDrawable inventory, IDrawable hotbar) {
        super(background, null, Color.WHITE.main, -12566464, false);
        this.slotHoverColor = slotHoverColor;
        this.useCustomSlotTextures = useCustomSlotTextures;
        this.inventorySlotBackground = inventory;
        this.hotbarSlotBackground = hotbar;
    }

    public WidgetSlotTheme(WidgetTheme parent, JsonObject json, JsonObject fallback) {
        super(parent, json, fallback);
        this.slotHoverColor = JsonHelper.getColorWithFallback(json, fallback, ((WidgetSlotTheme)parent).getSlotHoverColor(), "slotHoverColor");
        this.useCustomSlotTextures = JsonHelper.getBoolWithFallback(json, fallback, ((WidgetSlotTheme)parent).getUseCustomSlotTextures(), "useCustomSlotTextures");
        this.inventorySlotBackground = JsonHelper.deserializeWithFallback(json, fallback, IDrawable.class, ((WidgetSlotTheme)parent).getInventorySlotBackground(), "inventorySlotBackground");
        this.hotbarSlotBackground = JsonHelper.deserializeWithFallback(json, fallback, IDrawable.class, ((WidgetSlotTheme)parent).getHotbarSlotBackground(), "hotbarSlotBackground");
    }

    public int getSlotHoverColor() {
        return this.slotHoverColor;
    }

    public boolean getUseCustomSlotTextures() {
        return this.useCustomSlotTextures;
    }

    public IDrawable getInventorySlotBackground() {
        return this.inventorySlotBackground;
    }

    public IDrawable getHotbarSlotBackground() {
        return this.hotbarSlotBackground;
    }
}

