/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.serialization;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface IEquals<T> {
    public boolean areEqual(@NotNull T var1, @NotNull T var2);

    public static <T> IEquals<T> wrapNullSafe(IEquals<T> equals) {
        return (t1, t2) -> {
            if (t1 == null || t2 == null) {
                return t1 == t2;
            }
            return equals.areEqual(t1, t2);
        };
    }

    public static <T> IEquals<T> defaultTester() {
        return Objects::equals;
    }
}

