/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.utils.item.PlayerMainInvWrapper;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.PanelSyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PanelSyncManager {
    private final Map<String, SyncHandler> syncHandlers = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, SlotGroup> slotGroups = new Object2ObjectOpenHashMap();
    private final Map<SyncHandler, String> reverseSyncHandlers = new Object2ObjectOpenHashMap();
    private final Map<String, SyncHandler> subPanels = new Object2ObjectArrayMap();
    private ModularSyncManager modularSyncManager;
    private String panelName;
    private boolean init = true;
    private final List<Consumer<EntityPlayer>> openListener = new ArrayList<Consumer<EntityPlayer>>();
    private final List<Consumer<EntityPlayer>> closeListener = new ArrayList<Consumer<EntityPlayer>>();

    @ApiStatus.Internal
    public void initialize(String panelName, ModularSyncManager msm) {
        this.modularSyncManager = msm;
        this.panelName = panelName;
        this.syncHandlers.forEach((mapKey, syncHandler) -> syncHandler.init((String)mapKey, this));
        this.init = true;
        this.subPanels.forEach((s, syncHandler) -> msm.getMainPSM().registerPanelSyncHandler((String)s, (SyncHandler)syncHandler));
    }

    private void registerPanelSyncHandler(String name, SyncHandler syncHandler) {
        SyncHandler currentSh = this.syncHandlers.get(name);
        if (currentSh != null && currentSh != syncHandler) {
            throw new IllegalStateException();
        }
        String currentName = this.reverseSyncHandlers.get(syncHandler);
        if (currentName != null && !name.equals(currentName)) {
            throw new IllegalStateException();
        }
        this.syncHandlers.put(name, syncHandler);
        this.reverseSyncHandlers.put(syncHandler, name);
        syncHandler.init(name, this);
    }

    void closeSubPanels() {
        this.subPanels.values().forEach(syncHandler -> {
            if (syncHandler instanceof IPanelHandler) {
                IPanelHandler panelHandler = (IPanelHandler)((Object)syncHandler);
                if (panelHandler.isSubPanel()) {
                    panelHandler.closePanel();
                }
            } else {
                throw new IllegalStateException();
            }
        });
    }

    @ApiStatus.Internal
    public void onOpen() {
        this.openListener.forEach(listener -> listener.accept(this.getPlayer()));
    }

    @ApiStatus.Internal
    public void onClose() {
        this.closeListener.forEach(listener -> listener.accept(this.getPlayer()));
        for (String name : this.subPanels.keySet()) {
            SyncHandler sh = this.getModularSyncManager().getMainPSM().syncHandlers.remove(name);
            this.getModularSyncManager().getMainPSM().reverseSyncHandlers.remove(sh);
        }
    }

    public boolean isInitialised() {
        return this.modularSyncManager != null;
    }

    public void detectAndSendChanges(boolean init) {
        if (!this.isClient()) {
            for (SyncHandler syncHandler : this.syncHandlers.values()) {
                syncHandler.detectAndSendChanges(init || this.init);
            }
        }
        this.init = false;
    }

    public void receiveWidgetUpdate(String mapKey, int id, PacketBuffer buf) throws IOException {
        if (!this.syncHandlers.containsKey(mapKey)) {
            ModularUI.LOGGER.warn("SyncHandler \"{}\" does not exist for panel \"{}\"! ID was {}.", new Object[]{mapKey, this.panelName, id});
            return;
        }
        SyncHandler syncHandler = this.syncHandlers.get(mapKey);
        if (this.isClient()) {
            syncHandler.readOnClient(id, buf);
        } else {
            syncHandler.readOnServer(id, buf);
        }
    }

    public ItemStack getCursorItem() {
        return this.getModularSyncManager().getCursorItem();
    }

    public void setCursorItem(ItemStack stack) {
        this.getModularSyncManager().setCursorItem(stack);
    }

    public boolean hasSyncHandler(SyncHandler syncHandler) {
        return syncHandler.isValid() && syncHandler.getSyncManager() == this && this.reverseSyncHandlers.containsKey(syncHandler);
    }

    private void putSyncValue(String name, int id, SyncHandler syncHandler) {
        String key = PanelSyncManager.makeSyncKey(name, id);
        String currentKey = this.reverseSyncHandlers.get(syncHandler);
        if (currentKey != null) {
            if (!currentKey.equals(key)) {
                boolean auto = name.startsWith("auto_sync:");
                if (auto != currentKey.startsWith("auto_sync:")) {
                    throw new IllegalStateException("Old and new sync handler must both be either not auto or auto!");
                }
                if (auto && !currentKey.startsWith(name)) {
                    throw new IllegalStateException("Sync Handler was previously added with a different panel!");
                }
            }
            this.syncHandlers.remove(currentKey);
        }
        this.syncHandlers.put(key, syncHandler);
        this.reverseSyncHandlers.put(syncHandler, key);
        if (this.isInitialised()) {
            syncHandler.init(key, this);
        }
    }

    public PanelSyncManager syncValue(String name, SyncHandler syncHandler) {
        return this.syncValue(name, 0, syncHandler);
    }

    public PanelSyncManager syncValue(String name, int id, SyncHandler syncHandler) {
        Objects.requireNonNull(name, "Name must not be null");
        Objects.requireNonNull(syncHandler, "Sync Handler must not be null");
        this.putSyncValue(name, id, syncHandler);
        return this;
    }

    public PanelSyncManager syncValue(int id, SyncHandler syncHandler) {
        return this.syncValue("_", id, syncHandler);
    }

    public PanelSyncManager itemSlot(String key, ModularSlot slot) {
        return this.itemSlot(key, 0, slot);
    }

    public PanelSyncManager itemSlot(String key, int id, ModularSlot slot) {
        return this.syncValue(key, id, new ItemSlotSH(slot));
    }

    public PanelSyncManager itemSlot(int id, ModularSlot slot) {
        return this.itemSlot("_", id, slot);
    }

    public IPanelHandler panel(String key, PanelSyncHandler.IPanelBuilder panelBuilder, boolean subPanel) {
        SyncHandler sh = this.subPanels.get(key);
        if (sh != null) {
            return (IPanelHandler)((Object)sh);
        }
        PanelSyncHandler syncHandler = new PanelSyncHandler(panelBuilder, subPanel);
        this.subPanels.put(key, syncHandler);
        return syncHandler;
    }

    public PanelSyncManager registerSlotGroup(SlotGroup slotGroup) {
        if (!slotGroup.isSingleton()) {
            this.slotGroups.put(slotGroup.getName(), slotGroup);
        }
        return this;
    }

    public PanelSyncManager registerSlotGroup(String name, int rowSize, int shiftClickPriority) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, shiftClickPriority, true));
    }

    public PanelSyncManager registerSlotGroup(String name, int rowSize, boolean allowShiftTransfer) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, 100, allowShiftTransfer));
    }

    public PanelSyncManager registerSlotGroup(String name, int rowSize) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, 100, true));
    }

    public PanelSyncManager bindPlayerInventory(EntityPlayer player) {
        return this.bindPlayerInventory(player, ModularSlot::new);
    }

    public PanelSyncManager bindPlayerInventory(EntityPlayer player, @NotNull SlotFunction slotFunction) {
        if (this.getSlotGroup("player_inventory") != null) {
            throw new IllegalStateException("The player slot group is already registered!");
        }
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.field_71071_by);
        String key = "player";
        for (int i = 0; i < 36; ++i) {
            this.itemSlot(key, i, slotFunction.apply(playerInventory, i).slotGroup("player_inventory"));
        }
        this.registerSlotGroup(new SlotGroup("player_inventory", 9, 0, true).setAllowSorting(false));
        return this;
    }

    public PanelSyncManager addOpenListener(Consumer<EntityPlayer> listener) {
        this.openListener.add(listener);
        return this;
    }

    public PanelSyncManager addCloseListener(Consumer<EntityPlayer> listener) {
        this.closeListener.add(listener);
        return this;
    }

    public SlotGroup getSlotGroup(String name) {
        return this.slotGroups.get(name);
    }

    public Collection<SlotGroup> getSlotGroups() {
        return this.slotGroups.values();
    }

    public SyncHandler getSyncHandler(String mapKey) {
        return this.syncHandlers.get(mapKey);
    }

    public EntityPlayer getPlayer() {
        return this.getModularSyncManager().getPlayer();
    }

    public ModularSyncManager getModularSyncManager() {
        if (!this.isInitialised()) {
            throw new IllegalStateException("PanelSyncManager is not yet initialised!");
        }
        return this.modularSyncManager;
    }

    public ModularContainer getContainer() {
        return this.getModularSyncManager().getContainer();
    }

    public String getPanelName() {
        return this.panelName;
    }

    public boolean isClient() {
        return this.getModularSyncManager().isClient();
    }

    public static String makeSyncKey(String name, int id) {
        return name + ":" + id;
    }

    public static interface SlotFunction {
        @NotNull
        public ModularSlot apply(@NotNull PlayerMainInvWrapper var1, int var2);
    }
}

