/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IHoverable;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.Widget;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichTextWidget
extends Widget<RichTextWidget>
implements IRichTextBuilder<RichTextWidget>,
Interactable {
    private final RichText text = new RichText();
    private Consumer<RichText> builder;
    private boolean dirty = false;
    private boolean autoUpdate = false;

    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        super.draw(context, widgetTheme);
        if (this.autoUpdate || this.dirty) {
            if (this.builder != null) {
                this.text.clearText();
                this.builder.accept(this.text);
            }
            this.dirty = false;
        }
        this.text.drawAtZero((GuiContext)context, this.getArea(), widgetTheme);
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        super.drawForeground(context);
        Object o = this.text.getHoveringElement(context.getFontRenderer(), context.getMouseX(), context.getMouseY());
        if (o instanceof IHoverable) {
            IHoverable hoverable = (IHoverable)o;
            hoverable.onHover();
            RichTooltip tooltip = hoverable.getTooltip();
            if (tooltip != null) {
                tooltip.draw(context);
            }
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onMousePressed(mouseButton);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onMouseRelease(mouseButton);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onMouseTapped(mouseButton);
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onKeyPressed(typedChar, keyCode);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onKeyRelease(typedChar, keyCode);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(char typedChar, int keyCode) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onKeyTapped(typedChar, keyCode);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            return interactable.onMouseScroll(scrollDirection, amount);
        }
        return false;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        Object o = this.text.getHoveringElement(this.getContext().getFontRenderer(), this.getContext().getMouseX(), this.getContext().getMouseY());
        if (o instanceof Interactable) {
            Interactable interactable = (Interactable)o;
            interactable.onMouseDrag(mouseButton, timeSinceClick);
        }
    }

    @Nullable
    public Object getHoveredElement() {
        if (!this.isHovering()) {
            return null;
        }
        this.getContext().pushMatrix();
        this.getContext().translate(this.getArea().x, this.getArea().y);
        Object o = this.text.getHoveringElement(this.getContext());
        this.getContext().popMatrix();
        return o;
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTextWidget autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public RichTextWidget textBuilder(Consumer<RichText> builder) {
        this.builder = builder;
        this.markDirty();
        return this;
    }
}

