/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;

public class SlotGroup {
    public static final int PLAYER_INVENTORY_PRIO = 0;
    public static final int STORAGE_SLOT_PRIO = 100;
    private final String name;
    private final List<Slot> slots = new ArrayList<Slot>();
    private final int rowSize;
    private final int shiftClickPriority;
    private final boolean allowShiftTransfer;
    private boolean allowSorting = true;
    private final boolean singleton;

    public static SlotGroup singleton(String name, int shiftClickPriority) {
        return new SlotGroup(name, 1, shiftClickPriority, true, true);
    }

    public SlotGroup(String name, int rowSize) {
        this(name, rowSize, true);
    }

    public SlotGroup(String name, int rowSize, boolean allowShiftTransfer) {
        this(name, rowSize, 100, allowShiftTransfer);
    }

    public SlotGroup(String name, int rowSize, int shiftClickPriority, boolean allowShiftTransfer) {
        this(name, rowSize, shiftClickPriority, allowShiftTransfer, false);
    }

    private SlotGroup(String name, int rowSize, int shiftClickPriority, boolean allowShiftTransfer, boolean singleton) {
        this.name = name;
        this.rowSize = rowSize;
        this.shiftClickPriority = shiftClickPriority;
        this.allowShiftTransfer = allowShiftTransfer;
        this.singleton = singleton;
    }

    @ApiStatus.Internal
    void addSlot(Slot slot) {
        this.slots.add(slot);
        if (this.isSingleton() && this.slots.size() > 1) {
            throw new IllegalStateException("Singleton slot group has more than one slot!");
        }
    }

    @ApiStatus.Internal
    void removeSlot(ModularSlot slot) {
        this.slots.remove((Object)slot);
    }

    public int getShiftClickPriority() {
        return this.shiftClickPriority;
    }

    public List<Slot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public String getName() {
        return this.name;
    }

    public boolean allowShiftTransfer() {
        return this.allowShiftTransfer;
    }

    public boolean isAllowSorting() {
        return this.slots.size() > 1 && this.allowSorting;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public SlotGroup setAllowSorting(boolean allowSorting) {
        this.allowSorting = allowSorting;
        return this;
    }
}

