/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widgets.textfield.TextFieldHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TextFieldRenderer
extends TextRenderer {
    private static final DecimalFormat INTEGER_FIELD_FORMAT = new DecimalFormat("#");
    private static final char groupingSeparator = INTEGER_FIELD_FORMAT.getDecimalFormatSymbols().getGroupingSeparator();
    protected final TextFieldHandler handler;
    protected int markedColor = 3109544;
    protected int cursorColor = -1;
    protected boolean renderCursor = false;
    private boolean formatAsInteger = false;

    public TextFieldRenderer(TextFieldHandler handler) {
        this.handler = handler;
    }

    public void toggleCursor() {
        this.renderCursor = !this.renderCursor;
    }

    public void setCursor(boolean active) {
        this.renderCursor = active;
    }

    public void setMarkedColor(int markedColor) {
        this.markedColor = markedColor;
    }

    public void setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
    }

    @ApiStatus.Experimental
    public void setFormatAsInteger(boolean formatAsInteger) {
        this.formatAsInteger = formatAsInteger;
    }

    @Override
    public void draw(List<String> lines) {
        if (this.formatAsInteger) {
            lines = TextFieldRenderer.decorateLines(lines);
        }
        super.draw(lines);
    }

    @NotNull
    private static List<String> decorateLines(List<String> lines) {
        return lines.stream().map(TextFieldRenderer::tryFormatString).collect(Collectors.toList());
    }

    @NotNull
    private static String tryFormatString(String str) {
        try {
            return INTEGER_FIELD_FORMAT.format(Long.parseLong(str));
        }
        catch (NumberFormatException e) {
            return str;
        }
    }

    @Override
    protected void drawMeasuredLines(List<TextRenderer.Line> measuredLines) {
        this.drawMarked(measuredLines);
        super.drawMeasuredLines(measuredLines);
        if (this.renderCursor) {
            Point main = this.handler.getMainCursor();
            Point2D.Float start = this.getPosOf(measuredLines, main);
            if (this.handler.getText().get(main.y).isEmpty()) {
                start.x += 0.7f;
            }
            this.drawCursor(start.x, start.y);
        }
    }

    @Override
    public List<String> wrapLine(String line) {
        return Collections.singletonList(line);
    }

    protected void drawMarked(List<TextRenderer.Line> measuredLines) {
        if (!this.simulate && this.handler.hasTextMarked()) {
            Point2D.Float start = this.getPosOf(measuredLines, this.handler.getStartCursor());
            Point2D.Float end = this.getPosOf(measuredLines, this.handler.getEndCursor());
            if (start.y == end.y) {
                this.drawMarked(start.y, start.x, end.x);
            } else {
                int min = this.handler.getStartCursor().y;
                int max = this.handler.getEndCursor().y;
                TextRenderer.Line line = measuredLines.get(min);
                int startX = this.getStartX(line.getWidth());
                this.drawMarked(start.y, start.x, (float)startX + line.getWidth());
                start.y += this.getFontHeight();
                if (max - min > 1) {
                    for (int i = min + 1; i < max; ++i) {
                        line = measuredLines.get(i);
                        startX = this.getStartX(line.getWidth());
                        this.drawMarked(start.y, startX, (float)startX + line.getWidth());
                        start.y += this.getFontHeight();
                    }
                }
                line = measuredLines.get(max);
                startX = this.getStartX(line.getWidth());
                this.drawMarked(start.y, startX, end.x);
            }
        }
    }

    public Point getCursorPos(List<String> lines, int x, int y) {
        List<TextRenderer.Line> measuredLines;
        int index;
        if (lines.isEmpty()) {
            return new Point();
        }
        if (this.formatAsInteger) {
            lines = TextFieldRenderer.decorateLines(lines);
        }
        if ((index = (int)((float)(y -= this.getStartY((measuredLines = this.measureLines(lines)).size())) / this.getFontHeight())) < 0) {
            return new Point();
        }
        if (index >= measuredLines.size()) {
            return new Point(this.getRealLength(measuredLines.get(measuredLines.size() - 1).getText()), measuredLines.size() - 1);
        }
        TextRenderer.Line line = measuredLines.get(index);
        x -= this.getStartX(line.getWidth());
        if (line.getWidth() <= 0.0f) {
            return new Point(0, index);
        }
        if (line.getWidth() < (float)x) {
            return new Point(this.getRealLength(line.getText()), index);
        }
        float currentX = 0.0f;
        int ignoredChars = 0;
        for (int i = 0; i < line.getText().length(); ++i) {
            char c = line.getText().charAt(i);
            float charWidth = (float)TextFieldRenderer.getFontRenderer().func_78263_a(c) * this.scale;
            currentX += charWidth;
            if (this.isIgnoredChar(c)) {
                ++ignoredChars;
                continue;
            }
            if (!(currentX >= (float)x)) continue;
            if (Math.abs(currentX - (float)x) < Math.abs(currentX - charWidth - (float)x)) {
                ++i;
            }
            return new Point(i - ignoredChars, index);
        }
        return new Point();
    }

    @ApiStatus.Experimental
    protected boolean isIgnoredChar(int c) {
        return this.formatAsInteger && c == groupingSeparator;
    }

    private int getRealLength(String text) {
        int length = text.length();
        if (this.formatAsInteger) {
            length -= (int)text.chars().filter(this::isIgnoredChar).count();
        }
        return length;
    }

    public Point2D.Float getPosOf(List<TextRenderer.Line> measuredLines, Point cursorPos) {
        if (measuredLines.isEmpty()) {
            return new Point2D.Float(this.getStartX(0.0f), this.getStartYOfLines(1));
        }
        TextRenderer.Line line = measuredLines.get(cursorPos.y);
        String sub = this.getStringBeforeCursor(line, cursorPos);
        return new Point2D.Float((float)this.getStartX(line.getWidth()) + (float)TextFieldRenderer.getFontRenderer().func_78256_a(sub) * this.scale, (float)this.getStartYOfLines(measuredLines.size()) + (float)cursorPos.y * this.getFontHeight());
    }

    @ApiStatus.Experimental
    @NotNull
    private String getStringBeforeCursor(TextRenderer.Line line, Point cursorPos) {
        String text = line.getText();
        String sub = text.substring(0, Math.min(text.length(), cursorPos.x));
        if (this.formatAsInteger) {
            int i = 0;
            int ignoredChars = 0;
            while (i < sub.length() && i + ignoredChars < text.length()) {
                if (this.isIgnoredChar(text.charAt(i + ignoredChars))) {
                    ++ignoredChars;
                    continue;
                }
                ++i;
            }
            if (ignoredChars > 0) {
                sub = sub + text.substring(sub.length(), Math.min(text.length(), cursorPos.x + ignoredChars));
            }
        }
        return sub;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMarked(float y0, float x0, float x1) {
        float y1 = (y0 -= 1.0f) + this.getFontHeight();
        float red = Color.getRedF(this.markedColor);
        float green = Color.getGreenF(this.markedColor);
        float blue = Color.getBlueF(this.markedColor);
        float alpha = Color.getAlphaF(this.markedColor);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scale(this.scale, this.scale, 0.0f);
        TextFieldRenderer.drawRect(x0, y0, x1, y1, red, green, blue, alpha);
        GlStateManager.popMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCursor(float x0, float y0) {
        x0 = (x0 - 0.8f) / this.scale;
        y0 = (y0 - 1.0f) / this.scale;
        float x1 = x0 + 0.6f;
        float y1 = y0 + 9.0f;
        float red = Color.getRedF(this.cursorColor);
        float green = Color.getGreenF(this.cursorColor);
        float blue = Color.getBlueF(this.cursorColor);
        float alpha = Color.getAlphaF(this.cursorColor);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scale(this.scale, this.scale, 0.0f);
        TextFieldRenderer.drawRect(x0, y0, x1, y1, red, green, blue, alpha);
        GlStateManager.popMatrix();
    }

    private static void drawRect(float x0, float y0, float x1, float y1, float red, float green, float blue, float alpha) {
        Platform.setupDrawColor();
        GlStateManager.color(red, green, blue, alpha);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS, bufferBuilder -> {
            bufferBuilder.pos(x0, y1, 0.0).endVertex();
            bufferBuilder.pos(x1, y1, 0.0).endVertex();
            bufferBuilder.pos(x1, y0, 0.0).endVertex();
            bufferBuilder.pos(x0, y0, 0.0).endVertex();
        });
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        INTEGER_FIELD_FORMAT.setGroupingUsed(true);
        INTEGER_FIELD_FORMAT.setGroupingSize(3);
    }
}

