/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.block;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.opf.client.DownloadThread;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPicFrame
extends TileEntityCreative {
    @SideOnly(value=Side.CLIENT)
    public DownloadThread downloader;
    @SideOnly(value=Side.CLIENT)
    public int textureID;
    @SideOnly(value=Side.CLIENT)
    public boolean failed;
    public int renderDistance = 512;
    public String url = "";
    public float sizeX = 1.0f;
    public float sizeY = 1.0f;
    public boolean flippedX;
    public boolean flippedY;
    public byte rotation = 0;
    public byte posX = 0;
    public byte posY = 0;
    public boolean visibleFrame = true;

    public TileEntityPicFrame() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        this.textureID = -1;
        this.failed = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldLoadTexture() {
        return !this.isTextureLoaded() && !this.failed;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTexutre() {
        if (this.shouldLoadTexture()) {
            if (this.downloader == null) {
                Integer id = DownloadThread.loadedImages.get(this.url);
                if (id == null) {
                    if (!DownloadThread.loadingImages.contains(this.url)) {
                        DownloadThread.loadingImages.add(this.url);
                        this.downloader = new DownloadThread(this.url);
                    }
                } else {
                    this.textureID = id;
                }
            }
            if (this.downloader != null && this.downloader.hasFinished()) {
                if (this.downloader.hasFailed()) {
                    this.failed = true;
                } else {
                    this.textureID = DownloadThread.loadImage(this.downloader);
                }
                DownloadThread.loadingImages.remove(this.url);
                this.downloader = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isTextureLoaded() {
        return this.textureID != -1;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(this.renderDistance, 2.0);
    }

    public AxisAlignedBB getBoundingBox() {
        CubeObject cube = new CubeObject(0.0, 0.0, 0.0, 0.05, 1.0, 1.0);
        float sizeX = this.sizeX;
        float sizeY = this.sizeY;
        double offsetX = 0.0;
        double offsetY = 0.0;
        switch (this.rotation) {
            case 1: {
                sizeX = this.sizeY;
                sizeY = -this.sizeX;
                if (this.posY == 0) {
                    offsetY += 1.0;
                    break;
                }
                if (this.posY != 2) break;
                offsetY -= 1.0;
                break;
            }
            case 2: {
                sizeX = -this.sizeX;
                sizeY = -this.sizeY;
                if (this.posX == 0) {
                    offsetX += 1.0;
                } else if (this.posX == 2) {
                    offsetX -= 1.0;
                }
                if (this.posY == 0) {
                    offsetY += 1.0;
                    break;
                }
                if (this.posY != 2) break;
                offsetY -= 1.0;
                break;
            }
            case 3: {
                sizeX = -this.sizeY;
                sizeY = this.sizeX;
                if (this.posX == 0) {
                    offsetX += 1.0;
                    break;
                }
                if (this.posX != 2) break;
                offsetX -= 1.0;
            }
        }
        if (this.posX == 1) {
            offsetX += (double)(-sizeX + 1.0f) / 2.0;
        } else if (this.posX == 2) {
            offsetX += (double)(-sizeX + 1.0f);
        }
        if (this.posY == 1) {
            offsetY += (double)(-sizeY + 1.0f) / 2.0;
        } else if (this.posY == 2) {
            offsetY += (double)(-sizeY + 1.0f);
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.func_145832_p());
        if (direction == ForgeDirection.UP) {
            cube.minZ -= (double)(sizeX - 1.0f);
            cube.minY -= (double)(sizeY - 1.0f);
            cube.minZ -= offsetX;
            cube.maxZ -= offsetX;
            cube.minY -= offsetY;
            cube.maxY -= offsetY;
        } else {
            cube.maxZ += (double)(sizeX - 1.0f);
            cube.maxY += (double)(sizeY - 1.0f);
            cube.minZ += offsetX;
            cube.maxZ += offsetX;
            cube.minY += offsetY;
            cube.maxY += offsetY;
        }
        cube = new CubeObject(Math.min(cube.minX, cube.maxX), Math.min(cube.minY, cube.maxY), Math.min(cube.minZ, cube.maxZ), Math.max(cube.minX, cube.maxX), Math.max(cube.minY, cube.maxY), Math.max(cube.minZ, cube.maxZ));
        return CubeObject.rotateCube((CubeObject)cube, (ForgeDirection)direction).getAxis().func_72325_c((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("url", this.url);
        nbt.func_74776_a("sizeX", this.sizeX);
        nbt.func_74776_a("sizeY", this.sizeY);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74774_a("offsetX", this.posX);
        nbt.func_74774_a("offsetY", this.posY);
        nbt.func_74774_a("rotation", this.rotation);
        nbt.func_74757_a("visibleFrame", this.visibleFrame);
        nbt.func_74757_a("flippedX", this.flippedX);
        nbt.func_74757_a("flippedY", this.flippedY);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.url = nbt.func_74779_i("url");
        this.sizeX = nbt.func_74760_g("sizeX");
        this.sizeY = nbt.func_74760_g("sizeY");
        this.renderDistance = nbt.func_74762_e("render");
        this.posX = nbt.func_74771_c("offsetX");
        this.posY = nbt.func_74771_c("offsetY");
        this.rotation = nbt.func_74771_c("rotation");
        this.visibleFrame = nbt.func_74767_n("visibleFrame");
        this.flippedX = nbt.func_74767_n("flippedX");
        this.flippedY = nbt.func_74767_n("flippedY");
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        super.getDescriptionNBT(nbt);
        nbt.func_74778_a("url", this.url);
        nbt.func_74776_a("sizeX", this.sizeX);
        nbt.func_74776_a("sizeY", this.sizeY);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74774_a("offsetX", this.posX);
        nbt.func_74774_a("offsetY", this.posY);
        nbt.func_74774_a("rotation", this.rotation);
        nbt.func_74757_a("visibleFrame", this.visibleFrame);
        nbt.func_74757_a("flippedX", this.flippedX);
        nbt.func_74757_a("flippedY", this.flippedY);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.url = pkt.func_148857_g().func_74779_i("url");
        this.sizeX = pkt.func_148857_g().func_74760_g("sizeX");
        this.sizeY = pkt.func_148857_g().func_74760_g("sizeY");
        this.renderDistance = pkt.func_148857_g().func_74762_e("render");
        this.posX = pkt.func_148857_g().func_74771_c("offsetX");
        this.posY = pkt.func_148857_g().func_74771_c("offsetY");
        this.rotation = pkt.func_148857_g().func_74771_c("rotation");
        this.visibleFrame = pkt.func_148857_g().func_74767_n("visibleFrame");
        this.flippedX = pkt.func_148857_g().func_74767_n("flippedX");
        this.flippedY = pkt.func_148857_g().func_74767_n("flippedY");
        this.initClient();
        this.updateRender();
    }
}

