/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.gui;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Widget {
    public Rectangle position = new Rectangle(0, 0, 1, 1);
    public boolean visible = true;
    public boolean enabled = true;
    public ArrayList<Widget> children = Lists.newArrayList();
    protected boolean dragged = false;

    public final void addChild(Widget w) {
        if (w != null) {
            this.children.add(w);
        }
    }

    public final void update() {
        this.updateImpl();
        for (Widget w : this.children) {
            w.update();
        }
    }

    protected void updateImpl() {
    }

    public final boolean testPoint(int x, int y) {
        return this.visible && x >= this.position.x && y >= this.position.y && (double)x < this.position.getMaxX() && (double)y < this.position.getMaxY();
    }

    public final void draw(int mouseX, int mouseY, float partialTicks) {
        GL11.glTranslatef((float)this.position.x, (float)this.position.y, (float)0.0f);
        if (this.visible) {
            this.drawImpl(mouseX, mouseY, partialTicks);
            for (Widget w : this.children) {
                w.draw(mouseX - this.position.x, mouseY - this.position.y, partialTicks);
            }
        }
        GL11.glTranslatef((float)(-this.position.x), (float)(-this.position.y), (float)0.0f);
    }

    protected void drawImpl(int mouseX, int mouseY, float partialTicks) {
    }

    public final void drawForeground(int mouseX, int mouseY, float partialTicks) {
        GL11.glTranslatef((float)this.position.x, (float)this.position.y, (float)0.0f);
        if (this.visible) {
            this.drawForegroundImpl(mouseX, mouseY, partialTicks);
            for (Widget w : this.children) {
                w.drawForeground(mouseX - this.position.x, mouseY - this.position.y, partialTicks);
            }
        }
        GL11.glTranslatef((float)(-this.position.x), (float)(-this.position.y), (float)0.0f);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY, float partialTicks) {
    }

    public final boolean keyTyped(char character, int key) {
        if (this.keyTypedImpl(character, key)) {
            return true;
        }
        for (Widget w : this.children) {
            if (!w.keyTyped(character, key)) continue;
            return true;
        }
        return false;
    }

    protected boolean keyTypedImpl(char character, int key) {
        return false;
    }

    public final boolean mouseClicked(int x, int y, int button) {
        if (this.enabled && this.testPoint(x, y) && this.mouseClickedImpl(x, y, button)) {
            this.dragged = true;
            return true;
        }
        if (this.enabled && !this.testPoint(x, y)) {
            this.mouseClickedOutsideImpl(x, y, button);
        }
        for (Widget w : this.children) {
            if (!w.mouseClicked(x - this.position.x, y - this.position.y, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean mouseClickedImpl(int x, int y, int button) {
        return false;
    }

    protected void mouseClickedOutsideImpl(int x, int y, int button) {
    }

    public final boolean mouseMovedOrUp(int x, int y, int button) {
        this.dragged = false;
        if (this.enabled && this.testPoint(x, y) && this.mouseMovedOrUpImpl(x, y, button)) {
            return true;
        }
        for (Widget w : this.children) {
            if (!w.mouseMovedOrUp(x - this.position.x, y - this.position.y, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean mouseMovedOrUpImpl(int x, int y, int button) {
        return false;
    }

    public final boolean mouseClickMove(int x, int y, int lastBtn, long timeDragged) {
        if ((this.enabled && this.testPoint(x, y) || this.dragged) && this.mouseClickMoveImpl(x, y, lastBtn, timeDragged)) {
            return true;
        }
        for (Widget w : this.children) {
            if (!w.mouseClickMove(x - this.position.x, y - this.position.y, lastBtn, timeDragged)) continue;
            return true;
        }
        return false;
    }

    protected boolean mouseClickMoveImpl(int x, int y, int lastBtn, long timeDragged) {
        return false;
    }

    public final void clickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    public static void drawGradientRect(int xLeft, int yTop, int xRight, int yBottom, int topRGBA, int bottomRGBA, int zLevel) {
        float topA = (float)(topRGBA >> 24 & 0xFF) / 255.0f;
        float topR = (float)(topRGBA >> 16 & 0xFF) / 255.0f;
        float topG = (float)(topRGBA >> 8 & 0xFF) / 255.0f;
        float topB = (float)(topRGBA & 0xFF) / 255.0f;
        float bottomA = (float)(bottomRGBA >> 24 & 0xFF) / 255.0f;
        float bottomR = (float)(bottomRGBA >> 16 & 0xFF) / 255.0f;
        float bottomG = (float)(bottomRGBA >> 8 & 0xFF) / 255.0f;
        float bottomB = (float)(bottomRGBA & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(topR, topG, topB, topA);
        tessellator.func_78377_a((double)xRight, (double)yTop, (double)zLevel);
        tessellator.func_78377_a((double)xLeft, (double)yTop, (double)zLevel);
        tessellator.func_78369_a(bottomR, bottomG, bottomB, bottomA);
        tessellator.func_78377_a((double)xLeft, (double)yBottom, (double)zLevel);
        tessellator.func_78377_a((double)xRight, (double)yBottom, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public final void drawTooltip(int x, int y, String message) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        String[] msgLines = message.split("\n");
        int zLevel = 300;
        if (msgLines.length > 0) {
            int drawY;
            int drawX;
            int width = 0;
            for (drawX = 0; drawX < msgLines.length; ++drawX) {
                drawY = fontRendererObj.func_78256_a(msgLines[drawX]);
                if (drawY <= width) continue;
                width = drawY;
            }
            drawX = x + 12;
            drawY = y - 12;
            int height = 8;
            if (msgLines.length > 1) {
                height += 2 + (msgLines.length - 1) * 10;
            }
            int color1 = -267386864;
            Widget.drawGradientRect(drawX - 3, drawY - 4, drawX + width + 3, drawY - 3, -267386864, -267386864, zLevel);
            Widget.drawGradientRect(drawX - 3, drawY + height + 3, drawX + width + 3, drawY + height + 4, -267386864, -267386864, zLevel);
            Widget.drawGradientRect(drawX - 3, drawY - 3, drawX + width + 3, drawY + height + 3, -267386864, -267386864, zLevel);
            Widget.drawGradientRect(drawX - 4, drawY - 3, drawX - 3, drawY + height + 3, -267386864, -267386864, zLevel);
            Widget.drawGradientRect(drawX + width + 3, drawY - 3, drawX + width + 4, drawY + height + 3, -267386864, -267386864, zLevel);
            int color2 = 0x505000FF;
            int color3 = 1344798847;
            Widget.drawGradientRect(drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
            Widget.drawGradientRect(drawX + width + 2, drawY - 3 + 1, drawX + width + 3, drawY + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
            Widget.drawGradientRect(drawX - 3, drawY - 3, drawX + width + 3, drawY - 3 + 1, 0x505000FF, 0x505000FF, zLevel);
            Widget.drawGradientRect(drawX - 3, drawY + height + 2, drawX + width + 3, drawY + height + 3, 1344798847, 1344798847, zLevel);
            for (int i = 0; i < msgLines.length; ++i) {
                String var14 = msgLines[i];
                var14 = i == 0 ? '\u00a7' + Integer.toHexString(15) + var14 : "\u00a77" + var14;
                fontRendererObj.func_78261_a(var14, drawX, drawY, -1);
                if (i == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
        }
        GL11.glPopAttrib();
    }
}

