/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.dungeon.segment.ISegmentGenerator;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SegmentGeneratorBase
implements ISegmentGenerator {
    protected Segment arch;
    protected WeightedRandomizer<Segment> segments = new WeightedRandomizer();

    public SegmentGeneratorBase() {
        this.segments.add(new WeightedChoice<Segment>(Segment.SHELF, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.INSET, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.DOOR, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.FIREPLACE, 1));
        this.arch = Segment.ARCH;
    }

    public void add(Segment toAdd, int weight) {
        this.segments.add(new WeightedChoice<Segment>(toAdd, weight));
    }

    @Override
    public List<ISegment> genSegment(IWorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, Coord pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ArrayList<ISegment> segs = new ArrayList<ISegment>();
        for (Cardinal orth : Cardinal.orthogonal(dir)) {
            ISegment seg = this.pickSegment(editor, rand, level, dir, pos);
            if (seg == null) {
                return segs;
            }
            seg.generate(editor, rand, level, orth, level.getSettings().getTheme(), new Coord(pos));
            segs.add(seg);
        }
        if (!level.hasNearbyNode(pos) && rand.nextInt(3) == 0) {
            this.addSupport(editor, rand, level.getSettings().getTheme(), x, y, z);
        }
        return segs;
    }

    private ISegment pickSegment(IWorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, Coord pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if ((dir == Cardinal.NORTH || dir == Cardinal.SOUTH) && z % 3 == 0) {
            if (z % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand));
        }
        if ((dir == Cardinal.WEST || dir == Cardinal.EAST) && x % 3 == 0) {
            if (x % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand));
        }
        return null;
    }

    private void addSupport(IWorldEditor editor, Random rand, ITheme theme, int x, int y, int z) {
        if (!editor.isAirBlock(new Coord(x, y - 2, z))) {
            return;
        }
        editor.fillDown(rand, new Coord(x, y - 2, z), theme.getPrimaryPillar());
        IStair stair = theme.getPrimaryStair();
        stair.setOrientation(Cardinal.WEST, true);
        stair.set(editor, new Coord(x - 1, y - 2, z));
        stair.setOrientation(Cardinal.EAST, true);
        stair.set(editor, new Coord(x + 1, y - 2, z));
        stair.setOrientation(Cardinal.SOUTH, true);
        stair.set(editor, new Coord(x, y - 2, z + 1));
        stair.setOrientation(Cardinal.NORTH, true);
        stair.set(editor, new Coord(x, y - 2, z - 1));
    }
}

