/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.named;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import thaumcraft.api.aspects.Aspect;

public class AspectHandler
implements INamedArgumentHandler {
    public static final IArgumentHandler INSTANCE = new AspectHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        String peeked;
        TreeSet<Aspect> result = new TreeSet<Aspect>(AspectHelper.COMPARATOR);
        do {
            String tag = args.hasNext() ? (String)args.next() : "";
            Aspect aspect = AspectHelper.aspectsCI().get(tag);
            if (aspect == null) {
                throw new CommandException("salisarcana:error.invalid_aspect", new Object[]{tag});
            }
            result.add(aspect);
        } while (args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-"));
        return new ArrayList<Aspect>(result);
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        TreeSet<Aspect> alreadyIncluded = new TreeSet<Aspect>(AspectHelper.COMPARATOR);
        String peeked = null;
        do {
            String tag = (String)args.next();
            Aspect aspect = AspectHelper.aspectsCI().get(tag);
            if (aspect == null) continue;
            alreadyIncluded.add(aspect);
        } while (args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-"));
        if (!args.hasNext() || peeked != null && !peeked.startsWith("-")) {
            return AspectHelper.aspectsExcept(alreadyIncluded).stream().map(Aspect::getTag).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return List.class;
    }
}

