/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArrayHelper {
    public static String[] appendToArray(String[] array, String newValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null) {
            Collections.addAll(list, array);
        }
        list.add(newValue);
        return list.toArray(new String[0]);
    }

    public static int indexOf(int[] array, int key) {
        for (int index = 0; index < array.length; ++index) {
            if (array[index] != key) continue;
            return index;
        }
        return -1;
    }

    public static <E> TryGetResult<E> tryGet(E[] arr, int index) {
        if (0 <= index && index < arr.length) {
            return TryGetResult.success(arr[index]);
        }
        return TryGetResult.failure();
    }

    @Nonnull
    public static <T> List<T> toList(@Nullable T[] arr) {
        return ArrayHelper.toList(arr, ArrayList::new);
    }

    @Nonnull
    public static <T> List<T> toList(@Nullable T[] arr, Supplier<List<T>> listType) {
        List<T> result = listType.get();
        if (arr != null) {
            Collections.addAll(result, arr);
        }
        return result;
    }

    public static class TryGetResult<E> {
        private final boolean success;
        private final E data;

        public static <E> TryGetResult<E> success(E data) {
            return new TryGetResult<E>(true, data);
        }

        public static <E> TryGetResult<E> failure() {
            return new TryGetResult<Object>(false, null);
        }

        public TryGetResult(boolean success, E data) {
            this.success = success;
            this.data = data;
        }

        public boolean success() {
            return this.success;
        }

        public E data() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TryGetResult)) {
                return false;
            }
            TryGetResult that = (TryGetResult)o;
            return this.success == that.success && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.success, this.data);
        }
    }
}

