/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class MessageForgetAspects
implements IMessage,
IMessageHandler<MessageForgetAspects, IMessage> {
    public static final byte RESET_ACTION = 0;
    public static final byte FORGET_ACTION = 1;
    Aspect[] aspectsToReset = null;
    int aspectCount = 0;
    byte action = 0;

    public MessageForgetAspects() {
    }

    public MessageForgetAspects(byte action) {
        this.action = action;
    }

    public MessageForgetAspects(ArrayList<Aspect> aspects, byte action) {
        this.action = action;
        this.aspectCount = aspects.size();
        this.aspectsToReset = aspects.toArray(new Aspect[0]);
    }

    public void fromBytes(ByteBuf buf) {
        this.action = buf.readByte();
        this.aspectCount = buf.readInt();
        if (this.aspectCount > 0) {
            this.aspectCount = buf.readInt();
            this.aspectsToReset = new Aspect[this.aspectCount];
            for (int i = 0; i < this.aspectCount; ++i) {
                String tag = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.aspectsToReset[i] = Aspect.getAspect((String)tag);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.action);
        buf.writeInt(this.aspectCount);
        if (this.aspectCount > 0) {
            buf.writeInt(this.aspectsToReset.length);
            for (Aspect aspect : this.aspectsToReset) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)aspect.getTag());
            }
        }
    }

    public IMessage onMessage(MessageForgetAspects message, MessageContext ctx) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        AspectList playerAspects = (AspectList)playerKnowledge.aspectsDiscovered.get(player.func_70005_c_());
        if (message.aspectCount == 0) {
            if (message.action == 1) {
                playerAspects.aspects.clear();
            } else {
                for (Aspect aspect : playerAspects.getAspects()) {
                    playerAspects.aspects.put(aspect, 1);
                }
            }
        } else if (message.action == 1) {
            for (Aspect aspect : message.aspectsToReset) {
                playerAspects.aspects.remove(aspect);
            }
        } else {
            for (Aspect aspect : message.aspectsToReset) {
                playerAspects.aspects.put(aspect, 1);
            }
        }
        return null;
    }
}

