/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

public class AutoPlaceEnvironment {
    private IItemSource source;
    private final EntityPlayer actor;
    private final Consumer<IChatComponent> chatter;
    private final IStructureDefinition<?> definition;
    private final String piece;
    private final ExtendedFacing facing;
    final int[] offsetABC;
    private final int[] baseOffsetABC;

    public static AutoPlaceEnvironment fromLegacy(IItemSource source, EntityPlayer actor, Consumer<IChatComponent> chatter) {
        if (source instanceof WrappedIItemSource) {
            AutoPlaceEnvironment original = ((WrappedIItemSource)source).container;
            if (actor != original.actor || chatter != original.chatter) {
                AutoPlaceEnvironment newEnv = original;
                if (actor != original.actor) {
                    newEnv = newEnv.withActor(actor);
                }
                if (chatter != original.chatter) {
                    newEnv = newEnv.withChatter(chatter);
                }
                return newEnv;
            }
            return original;
        }
        return new AutoPlaceEnvironment(source, actor, chatter, null, null, null, null, null);
    }

    AutoPlaceEnvironment(EntityPlayer actor, Consumer<IChatComponent> chatter, IStructureDefinition<?> definition, String piece, ExtendedFacing facing, int[] baseOffsetABC) {
        this.source = null;
        this.actor = actor;
        this.chatter = chatter;
        this.definition = definition;
        this.piece = piece;
        this.facing = facing;
        this.offsetABC = new int[3];
        this.baseOffsetABC = baseOffsetABC;
    }

    AutoPlaceEnvironment(IItemSource source, EntityPlayer actor, Consumer<IChatComponent> chatter, IStructureDefinition<?> definition, String piece, ExtendedFacing facing, int[] offsetABC, int[] baseOffsetABC) {
        this.source = definition != null && !(source instanceof WrappedIItemSource) ? new WrappedIItemSource(this, source) : source;
        this.actor = actor;
        this.chatter = chatter;
        this.definition = definition;
        this.piece = piece;
        this.facing = facing;
        this.offsetABC = offsetABC;
        this.baseOffsetABC = baseOffsetABC;
    }

    protected AutoPlaceEnvironment(AutoPlaceEnvironment parent) {
        this(parent.getSource(), parent.getActor(), parent.getChatter(), parent.definition, parent.piece, parent.facing, parent.offsetABC, parent.baseOffsetABC);
    }

    void setSource(IItemSource source) {
        this.source = this.definition != null && !(source instanceof WrappedIItemSource) ? new WrappedIItemSource(this, source) : source;
    }

    public APILevel getAPILevel() {
        return this.definition == null ? (this.actor instanceof EntityPlayerMP ? APILevel.Legacy : APILevel.LegacyRelaxed) : APILevel.V2;
    }

    public IItemSource getSource() {
        return this.source;
    }

    public EntityPlayer getActor() {
        return this.actor;
    }

    public Consumer<IChatComponent> getChatter() {
        return this.chatter;
    }

    public boolean isContainedInPiece(int offsetA, int offsetB, int offsetC) {
        if (this.definition == null) {
            return false;
        }
        return this.definition.isContainedInStructure(this.piece, this.offsetABC[0] + offsetA + this.baseOffsetABC[0], this.offsetABC[1] + offsetB + this.baseOffsetABC[1], this.offsetABC[2] + offsetC + this.baseOffsetABC[2]);
    }

    public ExtendedFacing getFacing() {
        return this.facing;
    }

    public AutoPlaceEnvironment withSource(IItemSource source) {
        return new AutoPlaceEnvironment(source, this.actor, this.chatter, this.definition, this.piece, this.facing, this.offsetABC, this.baseOffsetABC);
    }

    public AutoPlaceEnvironment withActor(EntityPlayer actor) {
        return new AutoPlaceEnvironment(this.source, actor, this.chatter, this.definition, this.piece, this.facing, this.offsetABC, this.baseOffsetABC);
    }

    public AutoPlaceEnvironment withChatter(Consumer<IChatComponent> chatter) {
        return new AutoPlaceEnvironment(this.source, this.actor, chatter, this.definition, this.piece, this.facing, this.offsetABC, this.baseOffsetABC);
    }

    private static class WrappedIItemSource
    implements IItemSource {
        final AutoPlaceEnvironment container;
        final IItemSource delegate;

        public WrappedIItemSource(AutoPlaceEnvironment container, IItemSource delegate) {
            this.container = container;
            this.delegate = delegate;
        }

        @Override
        @Nonnull
        public Map<ItemStack, Integer> take(Predicate<ItemStack> predicate, boolean simulate, int count) {
            return this.delegate.take(predicate, simulate, count);
        }

        @Override
        public ItemStack takeOne(Predicate<ItemStack> predicate, boolean simulate) {
            return this.delegate.takeOne(predicate, simulate);
        }

        @Override
        public boolean takeAll(Predicate<ItemStack> predicate, boolean simulate, int count) {
            return this.delegate.takeAll(predicate, simulate, count);
        }

        @Override
        public boolean takeOne(ItemStack stack, boolean simulate) {
            return this.delegate.takeOne(stack, simulate);
        }

        @Override
        public boolean takeAll(ItemStack stack, boolean simulate) {
            return this.delegate.takeAll(stack, simulate);
        }
    }

    public static enum APILevel {
        Legacy,
        LegacyRelaxed,
        V2;

    }
}

