/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.client;

import codechicken.nei.recipe.HandlerInfo;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import ru.timeconqueror.tcneiadditions.TCNEIAdditions;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;

public class TCNAClient
implements IResourceManagerReloadListener {
    private final String[] UNLOCALIZED_COLORS = new String[]{"tcneiadditions.gui.textColor", "tcneiadditions.gui.instabilityColor0", "tcneiadditions.gui.instabilityColor1", "tcneiadditions.gui.instabilityColor2", "tcneiadditions.gui.instabilityColor3", "tcneiadditions.gui.instabilityColor4", "tcneiadditions.gui.instabilityColor5", "tcneiadditions.gui.researchNameColor", "tcneiadditions.gui.loadingTextColor"};
    public static final int NEI_RECIPE_HEIGHT = HandlerInfo.DEFAULT_HEIGHT;
    public static final int NEI_GUI_WIDTH = HandlerInfo.DEFAULT_WIDTH;
    public static final int NEI_GUI_HEIGHT = 131;
    private static final TCNAClient instance = new TCNAClient();
    private final Queue<FutureTask<?>> tasks = Queues.newArrayDeque();
    private Boolean wandRecipesDeleted = null;
    private HashMap<String, Integer> colors;

    public static TCNAClient getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onPlayerEntered(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.wandRecipesDeleted = true;
        for (Object craftingRecipe : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craftingRecipe instanceof ArcaneWandRecipe) && !(craftingRecipe instanceof ArcaneSceptreRecipe)) continue;
            this.wandRecipesDeleted = false;
            break;
        }
        if (this.wandRecipesDeleted.booleanValue()) {
            TCNEIAdditions.LOGGER.info("Detected removing of ArcaneWandRecipe and ArcaneSceptreRecipe by another mod. Applying NEI Wand Recipe searching by ShapedArcaneRecipes...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Queue<FutureTask<?>> queue = this.tasks;
            synchronized (queue) {
                while (!this.tasks.isEmpty()) {
                    FutureTask<?> task = this.tasks.poll();
                    task.run();
                    try {
                        task.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("tcneiadditions")) {
            TCNAConfig.syncConfig();
        }
    }

    public void registerResourceReloadListener() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager rm) {
        this.updateColorOverride();
    }

    private void updateColorOverride() {
        this.colors = new HashMap();
        for (String c : this.UNLOCALIZED_COLORS) {
            String hex = StatCollector.func_74838_a((String)c);
            int color = 0;
            if (hex.length() <= 6) {
                try {
                    color = Integer.parseUnsignedInt(hex, 16);
                }
                catch (NumberFormatException e) {
                    TCNEIAdditions.LOGGER.warn("Couldn't format color correctly for: " + c);
                }
            }
            this.colors.put(c, color);
        }
    }

    public int getColor(String key) {
        return this.colors.get(key) != null ? this.colors.get(key) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> addScheduledTask(@NotNull Runnable runnable) {
        Callable<Object> callable = Executors.callable(runnable);
        if (!this.isMainThread()) {
            ListenableFutureTask futureTask = ListenableFutureTask.create(callable);
            Queue<FutureTask<?>> queue = this.tasks;
            synchronized (queue) {
                this.tasks.add((FutureTask<?>)futureTask);
                return futureTask;
            }
        }
        try {
            return Futures.immediateFuture((Object)callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public boolean isMainThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    public boolean areWandRecipesDeleted() {
        return this.wandRecipesDeleted;
    }
}

