/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.config.Settings;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.tile.storage.TileChest;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.grid.EssentiaMonitor;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.items.ItemEssentiaCell;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.storage.AspectStackComparator;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerEssentiaCell
extends ContainerEssentiaCellTerminalBase {
    private final TileChest hostChest;
    private PlayerSource playerSource = null;
    private ISaveProvider chestSaveProvider;
    private Aspect tmpSelectedAspect;
    private TheInternalInventory privateInventory = new TheInternalInventory("thaumicenergistics.item.essentia.cell.inventory", 2, 64){

        @Override
        public boolean func_94041_b(int slotID, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };

    public ContainerEssentiaCell(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        this.hostChest = (TileChest)world.func_147438_o(x, y, z);
        if (EffectiveSide.isServerSide()) {
            TileChest hostObject = this.hostChest;
            this.chestSaveProvider = (ISaveProvider)hostObject;
            this.playerSource = new PlayerSource(this.player, (IActionHost)hostObject);
        } else {
            Packet_S_EssentiaCellTerminal.sendFullUpdateRequest(player);
        }
        this.bindToInventory(this.privateInventory);
    }

    private HandlerItemEssentiaCell getCellHandler() {
        if (this.hostChest == null) {
            return null;
        }
        ItemStack essentiaCell = this.hostChest.func_70301_a(1);
        if (essentiaCell == null || !(essentiaCell.func_77973_b() instanceof ItemEssentiaCell)) {
            return null;
        }
        return new HandlerItemEssentiaCell(essentiaCell, this.chestSaveProvider);
    }

    @Override
    protected BaseActionSource getActionSource() {
        return this.playerSource;
    }

    @Override
    protected IGrid getHostGrid() {
        try {
            return this.hostChest.getActionableNode().getGrid();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Aspect getHostSelectedAspect() {
        return this.tmpSelectedAspect;
    }

    @Override
    protected IMEEssentiaMonitor getNewMonitor() {
        try {
            IMEInventoryHandler handler = null;
            List hostCellArray = this.hostChest.getCellArray(StorageChannel.FLUIDS);
            if (hostCellArray.size() > 0) {
                handler = (IMEInventoryHandler)hostCellArray.get(0);
            }
            if (handler != null) {
                return new EssentiaMonitor((IMEMonitor<IAEFluidStack>)((IMEMonitor)handler), this.hostChest.getProxy().getEnergy(), this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected void setHostSelectedAspect(Aspect aspect) {
        this.tmpSelectedAspect = aspect;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.hostChest != null) {
            return this.hostChest.func_70300_a(player);
        }
        return false;
    }

    @Override
    public void doWork(int elapsedTicks) {
        this.transferEssentiaFromWorkSlots();
    }

    @Override
    public ICraftingIssuerHost getCraftingHost() {
        return null;
    }

    @Override
    public void onClientRequestAutoCraft(EntityPlayer player, Aspect aspect) {
    }

    @Override
    public void onClientRequestFullUpdate() {
        HandlerItemEssentiaCell cellHandler = this.getCellHandler();
        if (cellHandler != null) {
            Packet_C_EssentiaCellTerminal.sendViewingModes(this.player, cellHandler.getSortingMode(), cellHandler.getViewMode());
        }
        if (this.hostChest.isPowered()) {
            Packet_C_EssentiaCellTerminal.sendFullList(this.player, this.repo.getAll());
        } else {
            Packet_C_EssentiaCellTerminal.sendFullList(this.player, new ArrayList<IAspectStack>());
        }
    }

    @Override
    public void onClientRequestSortModeChange(EntityPlayer player, boolean backwards) {
        HandlerItemEssentiaCell cellHandler = this.getCellHandler();
        if (cellHandler != null) {
            AspectStackComparator.AspectStackComparatorMode sortingMode = backwards ? cellHandler.getSortingMode().previousMode() : cellHandler.getSortingMode().nextMode();
            cellHandler.setSortingMode(sortingMode);
            Packet_C_EssentiaCellTerminal.sendViewingModes(player, sortingMode, cellHandler.getViewMode());
        }
    }

    @Override
    public void onClientRequestCraftingStatus(EntityPlayer player) {
    }

    @Override
    public void onClientRequestViewModeChange(EntityPlayer player, boolean backwards) {
        HandlerItemEssentiaCell cellHandler = this.getCellHandler();
        if (cellHandler != null) {
            ViewItems viewMode = (ViewItems)Platform.rotateEnum((Enum)cellHandler.getViewMode(), (boolean)backwards, (EnumSet)Settings.VIEW_MODE.getPossibleValues());
            cellHandler.setViewMode(viewMode);
            Packet_C_EssentiaCellTerminal.sendViewingModes(player, cellHandler.getSortingMode(), viewMode);
        }
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        if (EffectiveSide.isServerSide()) {
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
        super.func_75134_a(player);
    }
}

