/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.config.RedstoneMode;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerWithNetworkTool;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaIOBus;
import thaumicenergistics.common.parts.ThEPartEssentiaIOBus_Base;

public class ContainerPartEssentiaIOBus
extends ContainerWithNetworkTool {
    private static final int NUMBER_OF_UPGRADE_SLOTS = 4;
    private static final int UPGRADE_X_POS = 187;
    private static final int UPGRADE_Y_POS = 8;
    private static final int PLAYER_INV_POSITION_Y = 102;
    private static final int HOTBAR_INV_POSITION_Y = 160;
    private final ThEPartEssentiaIOBus_Base bus;
    private boolean isVoidAllowed;
    private boolean isCraftingOnly;

    public ContainerPartEssentiaIOBus(ThEPartEssentiaIOBus_Base part, EntityPlayer player) {
        super(player);
        this.bus = part;
        this.bindPlayerInventory((IInventory)player.field_71071_by, 102, 160);
        this.addUpgradeSlots(part.getUpgradeInventory(), 4, 187, 8);
        this.bindToNetworkTool(player.field_71071_by, part.getHost().getLocation(), 0, 0);
        this.bus.addListener(this);
    }

    @Override
    protected boolean detectAndSendChangesMP(@Nonnull EntityPlayerMP playerMP) {
        if (this.isVoidAllowed != this.bus.isVoidAllowed()) {
            this.isVoidAllowed = this.bus.isVoidAllowed();
            Packet_C_EssentiaIOBus.sendVoidMode(this.player, this.isVoidAllowed);
        }
        if (this.isCraftingOnly != this.bus.isCraftingOnly()) {
            this.isCraftingOnly = this.bus.isCraftingOnly();
            Packet_C_EssentiaIOBus.sendCraftingMode(this.player, this.isCraftingOnly);
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.bus != null) {
            return this.bus.isPartUseableByPlayer(player);
        }
        return false;
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        if (this.bus != null) {
            this.bus.removeListener(this);
        }
    }

    public void setFilteredAspect(List<Aspect> filteredAspects) {
        Packet_C_AspectSlot.setFilterList(filteredAspects, this.player);
    }

    public void setFilterSize(byte filterSize) {
        Packet_C_EssentiaIOBus.sendFilterSize(this.player, filterSize);
    }

    public void setRedstoneControlled(boolean isRedstoneControlled) {
        Packet_C_EssentiaIOBus.sendRedstoneControlled(this.player, isRedstoneControlled);
    }

    public void setHasCraftingCard(boolean hasCraftingCard) {
        Packet_C_EssentiaIOBus.sendHasCraftingCard(this.player, hasCraftingCard);
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        Packet_C_EssentiaIOBus.sendRedstoneMode(this.player, redstoneMode);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            if (this.bus != null && this.bus.addFilteredAspectFromItemstack(player, slot.func_75211_c())) {
                return null;
            }
            return super.func_82846_b(player, slotNumber);
        }
        return null;
    }
}

