/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.features;

import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.Config;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.blocks.BlockEnum;
import thaumicenergistics.common.features.CommonDependantItems;
import thaumicenergistics.common.features.ThEThaumcraftResearchFeature;
import thaumicenergistics.common.registries.FeatureRegistry;
import thaumicenergistics.common.registries.RecipeRegistry;
import thaumicenergistics.common.registries.ResearchRegistry;

public class FeatureInfusionProvider
extends ThEThaumcraftResearchFeature {
    public FeatureInfusionProvider() {
        super(ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.getKey());
    }

    @Override
    protected boolean checkConfigs(IThEConfig theConfig) {
        return theConfig.craftInfusionProvider();
    }

    @Override
    protected Object[] getItemReqs(CommonDependantItems cdi) {
        return new Object[]{cdi.MEInterface};
    }

    @Override
    protected ThEThaumcraftResearchFeature getParentFeature() {
        return FeatureRegistry.instance().featureEssentiaIOBuses;
    }

    @Override
    protected void registerCrafting(CommonDependantItems cdi) {
        ItemStack CoalescenceCore = ThEApi.instance().items().CoalescenceCore.getStack();
        ItemStack InfusionProvider = ThEApi.instance().blocks().InfusionProvider.getStack();
        AspectList infusionProviderList = new AspectList();
        infusionProviderList.add(Aspect.MECHANISM, 64);
        infusionProviderList.add(Aspect.MAGIC, 32);
        infusionProviderList.add(Aspect.ORDER, 32);
        infusionProviderList.add(Aspect.EXCHANGE, 16);
        ItemStack[] infusionProviderRecipeItems = new ItemStack[]{cdi.EssentiaMirror, cdi.SalisMundus, CoalescenceCore, cdi.AirShard, cdi.EssentiaMirror, cdi.SalisMundus, CoalescenceCore, cdi.AirShard};
        RecipeRegistry.BLOCK_INFUSION_PROVIDER = ThaumcraftApi.addInfusionCraftingRecipe((String)this.researchKey, (Object)InfusionProvider, (int)4, (AspectList)infusionProviderList, (ItemStack)cdi.MEInterface, (ItemStack[])infusionProviderRecipeItems);
    }

    @Override
    protected void registerPseudoParents() {
        ResearchRegistry.PseudoResearchTypes.INFUSION.registerPsudeoResearch();
        if (Config.allowMirrors) {
            ResearchRegistry.PseudoResearchTypes.MIRROR.registerPsudeoResearch();
        } else {
            ResearchRegistry.PseudoResearchTypes.JAR.registerPsudeoResearch();
        }
    }

    @Override
    protected void registerResearch() {
        AspectList infusionProviderList = new AspectList();
        infusionProviderList.add(Aspect.MECHANISM, 3);
        infusionProviderList.add(Aspect.MAGIC, 3);
        infusionProviderList.add(Aspect.EXCHANGE, 7);
        infusionProviderList.add(Aspect.MOTION, 7);
        infusionProviderList.add(Aspect.SENSES, 5);
        ItemStack infusionProviderIcon = new ItemStack(BlockEnum.INFUSION_PROVIDER.getBlock(), 1);
        ResearchPage[] infusionProviderPages = new ResearchPage[]{new ResearchPage(ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_INFUSION_PROVIDER)};
        String researchKeyMirrorOrJar = Config.allowMirrors ? "MIRROR" : "JARLABEL";
        String pseudoKeyMirrorOrJar = Config.allowMirrors ? ResearchRegistry.PseudoResearchTypes.MIRROR.getKey() : ResearchRegistry.PseudoResearchTypes.JAR.getKey();
        ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.createResearchItem(infusionProviderList, 3, infusionProviderIcon, infusionProviderPages);
        ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.researchItem.setParents(new String[]{this.getFirstValidParentKey(false), pseudoKeyMirrorOrJar, ResearchRegistry.PseudoResearchTypes.INFUSION.getKey()});
        ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.researchItem.setParentsHidden(new String[]{researchKeyMirrorOrJar, "INFUSION"});
        ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.researchItem.setConcealed().setSpecial();
        ResearchRegistry.ResearchTypes.INFUSION_PROVIDER.researchItem.registerResearchItem();
    }
}

