/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.relauncher.Side;
import glowredman.txloader.RemoteHandler;
import glowredman.txloader.TXLoaderCore;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

class JarHandler {
    static final Map<String, Path> CACHED_CLIENT_JARS = new HashMap<String, Path>();
    static final Map<String, Path> CACHED_SERVER_JARS = new HashMap<String, Path>();
    static Path txloaderCache;

    JarHandler() {
    }

    static void indexJars() {
        String userHome = System.getProperty("user.home");
        String system = System.getProperty("os.name").toLowerCase();
        try {
            if (system.contains("win")) {
                String temp = System.getenv("TEMP");
                String localAppData = System.getenv("LOCALAPPDATA");
                txloaderCache = temp != null ? Paths.get(temp, "txloader") : (localAppData != null ? Paths.get(localAppData, "Temp", "txloader") : Paths.get(userHome, "AppData", "Local", "Temp", "txloader"));
            } else {
                String xdgCacheHome;
                txloaderCache = system.contains("mac") ? Paths.get(userHome, "Library", "Caches", "txloader") : ((xdgCacheHome = System.getenv("XDG_CACHE_HOME")) == null ? Paths.get(userHome, ".cache", "txloader") : Paths.get(xdgCacheHome, "txloader"));
            }
        }
        catch (InvalidPathException e) {
            txloaderCache = system.contains("win") ? Paths.get(userHome, "AppData", "Local", "Temp", "txloader") : Paths.get(userHome, ".cache", "txloader");
            TXLoaderCore.LOGGER.warn("An error occurred while the TXLoader cache path was created. The environment variable TEMP or LOCALAPPDATA could be set incorrectly. Using the default cache location: {}", new Object[]{txloaderCache, e});
        }
        ArrayList<Pair> clientLocations = new ArrayList<Pair>();
        clientLocations.add(Pair.of((Object)txloaderCache, (Object)"client.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, "AppData", "Roaming", ".minecraft", "versions"), (Object)"%s.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "forge_gradle", "minecraft_repo", "versions"), (Object)"client.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "minecraft", "net", "minecraft", "minecraft"), (Object)"minecraft-%s.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "retro_futura_gradle", "mc-vanilla"), (Object)"client.jar"));
        ArrayList<Pair> serverLocations = new ArrayList<Pair>();
        serverLocations.add(Pair.of((Object)txloaderCache, (Object)"server.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "forge_gradle", "minecraft_repo", "versions"), (Object)"server.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "minecraft", "net", "minecraft", "minecraft_server"), (Object)"minecraft_server-%s.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "retro_futura_gradle", "mc-vanilla"), (Object)"server.jar"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Pair location : clientLocations) {
            JarHandler.collect((Path)location.getLeft(), (String)location.getRight(), Side.CLIENT);
        }
        for (Pair location : serverLocations) {
            JarHandler.collect((Path)location.getLeft(), (String)location.getRight(), Side.SERVER);
        }
        TXLoaderCore.LOGGER.debug("Scan for jars took {}ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    private static void collect(final Path start, final String fileName, final Side side) {
        if (!Files.isDirectory(start, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!Files.isSameFile(dir, start) && !RemoteHandler.VERSIONS.containsKey(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path parent = file.getParent();
                    if (Files.isSameFile(parent, start) || !attrs.isRegularFile() || attrs.size() <= 1024L) {
                        return FileVisitResult.CONTINUE;
                    }
                    String version = parent.getFileName().toString();
                    if (!String.format(fileName, version).equals(file.getFileName().toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (side.isClient()) {
                        CACHED_CLIENT_JARS.put(version, file);
                    } else {
                        CACHED_SERVER_JARS.put(version, file);
                    }
                    TXLoaderCore.LOGGER.debug("Found {} jar for version {} at {}", new Object[]{side, version, file});
                    return FileVisitResult.SKIP_SIBLINGS;
                }
            });
        }
        catch (IOException e) {
            TXLoaderCore.LOGGER.debug("Cannot walk cache directory {}", new Object[]{start, e});
        }
    }
}

