/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class TransferCache {
    public static final TransferCache instance = new TransferCache();
    private final Map<String, List<OreVeinPosition>> sharedOreVeins = new HashMap<String, List<OreVeinPosition>>();
    private final Map<String, List<UndergroundFluidPosition>> sharedUndergroundFluids = new HashMap<String, List<UndergroundFluidPosition>>();
    private final Queue<String> timestamp = new LinkedList<String>();

    public void addClientProspectionData(String uuid, List<OreVeinPosition> oreVeins, List<UndergroundFluidPosition> undergroundFluids) {
        this.sharedOreVeins.remove(uuid);
        this.sharedUndergroundFluids.remove(uuid);
        this.timestamp.remove(uuid);
        int newEntryBytes = oreVeins.size() * 14 + undergroundFluids.size() * 272;
        while (this.getUsedMemory() > (Config.maxTransferCacheSizeMB << 20) - newEntryBytes && !this.timestamp.isEmpty()) {
            String oldestUUID = this.timestamp.remove();
            this.sharedOreVeins.remove(oldestUUID);
            this.sharedUndergroundFluids.remove(oldestUUID);
        }
        this.sharedOreVeins.put(uuid, oreVeins);
        this.sharedUndergroundFluids.put(uuid, undergroundFluids);
        this.timestamp.add(uuid);
    }

    public boolean isClientDataAvailable(String uuid) {
        return this.sharedOreVeins.containsKey(uuid) && this.sharedUndergroundFluids.containsKey(uuid);
    }

    public List<OreVeinPosition> getSharedOreVeinsFrom(String uuid) {
        return this.sharedOreVeins.getOrDefault(uuid, new ArrayList());
    }

    public List<UndergroundFluidPosition> getSharedUndergroundFluidsFrom(String uuid) {
        return this.sharedUndergroundFluids.getOrDefault(uuid, new ArrayList());
    }

    private int getUsedMemory() {
        return this.sharedOreVeins.values().stream().mapToInt(oreVeins -> oreVeins.size() * 14).sum() + this.sharedUndergroundFluids.values().stream().mapToInt(undergroundFluids -> undergroundFluids.size() * 272).sum();
    }
}

