/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.registry.WorldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class SchematicWriter
implements ClipboardWriter {
    private static final int MAX_SIZE = 65535;
    private final NBTOutputStream outputStream;

    public SchematicWriter(NBTOutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void write(Clipboard clipboard, WorldData data) throws IOException {
        Region region = clipboard.getRegion();
        Vector origin = clipboard.getOrigin();
        Vector min = region.getMinimumPoint();
        Vector offset = min.subtract(origin);
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 65535) {
            throw new IllegalArgumentException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new IllegalArgumentException("Length of region too large for a .schematic");
        }
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Width", new ShortTag((short)width));
        schematic.put("Length", new ShortTag((short)length));
        schematic.put("Height", new ShortTag((short)height));
        schematic.put("Materials", new StringTag("Alpha"));
        schematic.put("WEOriginX", new IntTag(min.getBlockX()));
        schematic.put("WEOriginY", new IntTag(min.getBlockY()));
        schematic.put("WEOriginZ", new IntTag(min.getBlockZ()));
        schematic.put("WEOffsetX", new IntTag(offset.getBlockX()));
        schematic.put("WEOffsetY", new IntTag(offset.getBlockY()));
        schematic.put("WEOffsetZ", new IntTag(offset.getBlockZ()));
        final HashMap<String, Tag> blockMapping = new HashMap<String, Tag>();
        final HashMap<String, Tag> itemMapping = new HashMap<String, Tag>();
        byte[] blocks = new byte[width * height * length];
        byte[] addBlocks = null;
        byte[] addBlocks2 = null;
        byte[] blockData = new byte[width * height * length];
        byte[] addData = null;
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (Object point : region) {
            CompoundTag rawTag;
            Vector vector = ((Vector)point).subtract(min);
            int x = vector.getBlockX();
            int y = vector.getBlockY();
            int z = vector.getBlockZ();
            int index = y * width * length + z * width + x;
            BaseBlock block = clipboard.getBlock((Vector)point);
            if (block.getType() > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[index >> 1] = (byte)((index & 1) == 0 ? addBlocks[index >> 1] & 0xF0 | block.getType() >> 8 & 0xF : addBlocks[index >> 1] & 0xF | (block.getType() >> 8 & 0xF) << 4);
            }
            if (block.getType() > 4095) {
                if (addBlocks2 == null) {
                    addBlocks2 = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks2[index >> 1] = (byte)((index & 1) == 0 ? addBlocks2[index >> 1] & 0xF0 | block.getType() >> 12 & 0xF : addBlocks2[index >> 1] & 0xF | (block.getType() >> 12 & 0xF) << 4);
            }
            blockMapping.put(Block.field_149771_c.func_148750_c((Object)Block.func_149729_e((int)block.getId())), new ShortTag((short)block.getId()));
            blocks[index] = (byte)block.getType();
            blockData[index] = (byte)block.getData();
            if (block.getData() > 15) {
                if (addData == null) {
                    addData = new byte[blockData.length];
                }
                addData[index] = (byte)(block.getData() >> 8);
            }
            if ((rawTag = block.getNbtData()) == null) continue;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            for (Map.Entry entry : rawTag.getValue().entrySet()) {
                values.put((String)entry.getKey(), (Tag)entry.getValue());
            }
            values.put("id", new StringTag(block.getNbtId()));
            values.put("x", new IntTag(x));
            values.put("y", new IntTag(y));
            values.put("z", new IntTag(z));
            CompoundTag tileEntityTag = new CompoundTag(values);
            tileEntities.add(tileEntityTag);
            final BiPredicate<CompoundTag, String[]> isItem = (itemTag, idPtr) -> {
                idPtr[0] = "id";
                if ("id" != null && itemTag.containsKey("id") && itemTag.containsKey("Count")) {
                    if (itemTag.containsKey("Damage")) return true;
                }
                idPtr[0] = "Item";
                if ("Item" != null && itemTag.containsKey("Item") && itemTag.containsKey("Count")) {
                    if (itemTag.containsKey("Meta")) return true;
                }
                idPtr[0] = "id";
                if ("id" == null) return false;
                if (!itemTag.containsKey("id")) return false;
                if (!(itemTag.getValue().get("id") instanceof IntTag)) return false;
                return true;
            };
            Consumer<CompoundTag> convertItems = new Consumer<CompoundTag>(){

                @Override
                public void accept(CompoundTag nbtData) {
                    String[] idPtr = new String[1];
                    if (isItem.test(nbtData, idPtr)) {
                        Object v;
                        short id;
                        if (nbtData.getValue().get(idPtr[0]) instanceof IntTag) {
                            int id_data = nbtData.getInt(idPtr[0]);
                            id = (short)id_data;
                        } else {
                            id = nbtData.getShort(idPtr[0]);
                        }
                        itemMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)Short.toUnsignedInt(id))), new ShortTag(id));
                        if (nbtData.containsKey("tag") && (v = nbtData.getValue().get("tag")) instanceof CompoundTag) {
                            CompoundTag nbt = (CompoundTag)v;
                            this.accept(nbt);
                        }
                        if (nbtData.containsKey("d") && (v = nbtData.getValue().get("d")) instanceof CompoundTag) {
                            CompoundTag d = (CompoundTag)v;
                            this.accept(d);
                        }
                    } else {
                        StringTag str;
                        Object d;
                        if (nbtData.containsKey("id") && (d = nbtData.getValue().get("id")) instanceof StringTag && "customDoorTileEntity".equals((str = (StringTag)d).getValue())) {
                            Object _id5;
                            Object _id22;
                            Object _id32;
                            Object _id42;
                            IntTag itag;
                            Object v;
                            if (nbtData.containsKey("bottomMaterial") && (v = nbtData.getValue().get("bottomMaterial")) instanceof IntTag) {
                                itag = (IntTag)v;
                                int _id42 = itag.getValue();
                                itemMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)_id42)), new ShortTag((short)_id42));
                            }
                            if (nbtData.containsKey("topMaterial") && (_id42 = nbtData.getValue().get("topMaterial")) instanceof IntTag) {
                                itag = (IntTag)_id42;
                                int _id32 = itag.getValue();
                                itemMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)_id32)), new ShortTag((short)_id32));
                            }
                            if (nbtData.containsKey("frame") && (_id32 = nbtData.getValue().get("frame")) instanceof IntTag) {
                                itag = (IntTag)_id32;
                                int _id22 = itag.getValue();
                                itemMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)_id22)), new ShortTag((short)_id22));
                            }
                            if (nbtData.containsKey("block") && (_id22 = nbtData.getValue().get("block")) instanceof IntTag) {
                                itag = (IntTag)_id22;
                                int _id5 = itag.getValue();
                                blockMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)_id5)), new ShortTag((short)_id5));
                            }
                            if (nbtData.containsKey("item") && (_id5 = nbtData.getValue().get("item")) instanceof IntTag) {
                                itag = (IntTag)_id5;
                                int _id6 = itag.getValue();
                                itemMapping.put(Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)_id6)), new ShortTag((short)_id6));
                            }
                        }
                        for (Tag tag : nbtData.getValue().values()) {
                            if (tag instanceof ListTag) {
                                ListTag inventoryTag = (ListTag)tag;
                                Iterator iterator = inventoryTag.getValue().iterator();
                                while (iterator.hasNext()) {
                                    Tag tag2 = (Tag)iterator.next();
                                    if (!(tag2 instanceof CompoundTag)) continue;
                                    CompoundTag itemTag = (CompoundTag)tag2;
                                    this.accept(itemTag);
                                }
                                continue;
                            }
                            if (!(tag instanceof CompoundTag)) continue;
                            CompoundTag itemTag = (CompoundTag)tag;
                            this.accept(itemTag);
                        }
                    }
                }
            };
            convertItems.accept(tileEntityTag);
        }
        schematic.put("Blocks", new ByteArrayTag(blocks));
        schematic.put("Data", new ByteArrayTag(blockData));
        schematic.put("TileEntities", new ListTag(CompoundTag.class, tileEntities));
        if (addBlocks != null) {
            schematic.put("AddBlocks", new ByteArrayTag(addBlocks));
        }
        if (addBlocks2 != null) {
            schematic.put("AddBlocks2", new ByteArrayTag(addBlocks2));
        }
        if (addData != null) {
            schematic.put("AddData", new ByteArrayTag(addData));
        }
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (Entity entity : clipboard.getEntities()) {
            BaseEntity state = entity.getState();
            if (state == null) continue;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            CompoundTag rawTag = state.getNbtData();
            if (rawTag != null) {
                values.putAll((Map<String, Tag>)rawTag.getValue());
            }
            values.put("id", new StringTag(state.getTypeId()));
            values.put("Pos", this.writeVector(entity.getLocation().toVector(), "Pos"));
            values.put("Rotation", this.writeRotation(entity.getLocation(), "Rotation"));
            CompoundTag entityTag = new CompoundTag(values);
            entities.add(entityTag);
        }
        schematic.put("Entities", new ListTag(CompoundTag.class, entities));
        schematic.put("BlockMapping", new CompoundTag(blockMapping));
        schematic.put("ItemMapping", new CompoundTag(itemMapping));
        CompoundTag schematicTag = new CompoundTag(schematic);
        this.outputStream.writeNamedTag("Schematic", schematicTag);
    }

    private Tag writeVector(Vector vector, String name) {
        ArrayList<DoubleTag> list = new ArrayList<DoubleTag>();
        list.add(new DoubleTag(vector.getX()));
        list.add(new DoubleTag(vector.getY()));
        list.add(new DoubleTag(vector.getZ()));
        return new ListTag(DoubleTag.class, list);
    }

    private Tag writeRotation(Location location, String name) {
        ArrayList<FloatTag> list = new ArrayList<FloatTag>();
        list.add(new FloatTag(location.getYaw()));
        list.add(new FloatTag(location.getPitch()));
        return new ListTag(FloatTag.class, list);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

