/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.compat;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.transform.BlockTransformHook;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;

public class ArchitectureCraftBlockTransformHook
implements BlockTransformHook {
    private byte[] y_rotations = new byte[]{2, 5, 3, 4};
    private byte[] x_rotations = new byte[]{0, 3, 1, 2};
    private byte[] z_rotations = new byte[]{0, 5, 1, 4};

    @Override
    public BaseBlock transformBlock(BaseBlock block, Transform transform) {
        int idx;
        int ticks;
        CompoundTag nbt = block.getNbtData();
        if (nbt == null) {
            return block;
        }
        if (!"gcewing.shape".equals(nbt.getString("id"))) {
            return block;
        }
        if (!(transform instanceof AffineTransform)) {
            return block;
        }
        AffineTransform affine = (AffineTransform)transform;
        Vector rot = affine.getRotations();
        if (rot.lengthSq() == 0.0) {
            return block;
        }
        rot = rot.setX((360.0 - rot.getX()) % 360.0).setZ((360.0 - rot.getZ()) % 360.0);
        byte side = nbt.getByte("side");
        byte turn = nbt.getByte("turn");
        if (rot.getY() > 0.0) {
            ticks = (int)Math.round(rot.getY() / 90.0);
            if (side == 0) {
                turn = (byte)((turn + ticks) % 4);
            } else if (side == 1) {
                turn = (byte)((turn + 4 - ticks) % 4);
            } else {
                idx = this.rotationIndex(this.y_rotations, side);
                side = this.y_rotations[(idx + 4 - ticks) % 4];
            }
        }
        if (rot.getX() > 0.0) {
            ticks = (int)Math.round(rot.getX() / 90.0);
            if (side == 4) {
                turn = (byte)((turn + ticks) % 4);
            } else if (side == 5) {
                turn = (byte)((turn + 4 - ticks) % 4);
            } else {
                idx = this.rotationIndex(this.x_rotations, side);
                side = this.x_rotations[idx = (idx + ticks) % 4];
                if (side == 3) {
                    turn = (byte)((turn + 2) % 4);
                }
            }
        }
        if (rot.getZ() > 0.0) {
            ticks = (int)Math.round(rot.getZ() / 90.0);
            if (side == 3) {
                turn = (byte)((turn + ticks) % 4);
            } else if (side == 2) {
                turn = (byte)((turn + 4 - ticks) % 4);
            } else {
                idx = this.rotationIndex(this.z_rotations, side);
                side = this.z_rotations[(idx + 4 - ticks) % 4];
                turn = (byte)((turn + 4 - ticks) % 4);
            }
        }
        CompoundTagBuilder newNbt = nbt.createBuilder();
        turn = (byte)((turn + 4) % 4);
        newNbt.putByte("side", side);
        newNbt.putByte("turn", turn);
        return new BaseBlock(block.getId(), block.getData(), newNbt.build());
    }

    private int rotationIndex(byte[] rotations, byte side) {
        for (int i = 0; i < rotations.length; ++i) {
            if (rotations[i] != side) continue;
            return i;
        }
        return -1;
    }
}

