/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.compat;

import codechicken.multipart.MultipartHelper;
import codechicken.multipart.TileMultipart;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.jnbt.ListTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.transform.BlockTransformHook;
import com.sk89q.worldedit.forge.compat.ForgeMultipartCompat;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ForgeMultipartExistsCompat
implements ForgeMultipartCompat,
BlockTransformHook {
    private int[][] edge_rotations = new int[][]{{4, 10, 5, 8}, {6, 11, 7, 9}, {2, 0, 1, 3}};
    private int[][] post_rotations = new int[][]{{0}, {1}, {2}};
    private int[][] cnr_rotations = new int[][]{{0, 2, 6, 4}, {1, 3, 7, 5}};
    private int[][] face_rotations = new int[][]{{0}, {2, 5, 3, 4}, {1}};

    @Override
    public TileEntity overrideTileEntity(World world, @Nullable NBTTagCompound tag, TileEntity normal) {
        if (tag == null) {
            return normal;
        }
        TileEntity tile = MultipartHelper.createTileFromNBT((World)world, (NBTTagCompound)tag);
        if (tile == null) {
            return normal;
        }
        return tile;
    }

    @Override
    public void sendDescPacket(World world, TileEntity entity) {
        if (entity instanceof TileMultipart) {
            TileMultipart multi = (TileMultipart)entity;
            MultipartHelper.sendDescPacket((World)world, (TileEntity)multi);
            NBTTagCompound nbt = new NBTTagCompound();
            multi.func_145841_b(nbt);
        }
    }

    private int rotateSlot(int[][] edge_rotations, int slot, int ticks) {
        for (int type = 0; type < edge_rotations.length; ++type) {
            int[] rotations = edge_rotations[type];
            for (int i = 0; i < rotations.length; ++i) {
                if (rotations[i] != slot) continue;
                ticks = ticks % rotations.length + rotations.length;
                slot = rotations[(i + ticks) % rotations.length];
                return slot;
            }
        }
        return -1;
    }

    private int rotateEdgeSlot(Vector rot, int slot) {
        int n;
        if (rot.getY() > 0.0) {
            int ticks = (int)Math.round(rot.getY() / 90.0);
            slot = this.rotateSlot(this.edge_rotations, slot, ticks);
        }
        if (rot.getX() < 0.0) {
            n = (int)Math.round(rot.getX() / 90.0);
        }
        if (rot.getZ() > 0.0) {
            n = (int)Math.round(rot.getZ() / 90.0);
        }
        return slot;
    }

    private int rotatePostSlot(Vector rot, int slot) {
        int n;
        if (rot.getY() > 0.0) {
            int ticks = (int)Math.round(rot.getY() / 90.0);
            slot = this.rotateSlot(this.post_rotations, slot, ticks);
        }
        if (rot.getX() < 0.0) {
            n = (int)Math.round(rot.getX() / 90.0);
        }
        if (rot.getZ() > 0.0) {
            n = (int)Math.round(rot.getZ() / 90.0);
        }
        return slot;
    }

    private int rotateCnrSlot(Vector rot, int slot) {
        int n;
        if (rot.getY() > 0.0) {
            int ticks = (int)Math.round(rot.getY() / 90.0);
            slot = this.rotateSlot(this.cnr_rotations, slot, ticks);
        }
        if (rot.getX() < 0.0) {
            n = (int)Math.round(rot.getX() / 90.0);
        }
        if (rot.getZ() > 0.0) {
            n = (int)Math.round(rot.getZ() / 90.0);
        }
        return slot;
    }

    private int rotateFaceSlot(Vector rot, int slot) {
        int n;
        if (rot.getY() > 0.0) {
            int ticks = (int)Math.round(rot.getY() / 90.0);
            slot = this.rotateSlot(this.face_rotations, slot, ticks);
        }
        if (rot.getX() < 0.0) {
            n = (int)Math.round(rot.getX() / 90.0);
        }
        if (rot.getZ() > 0.0) {
            n = (int)Math.round(rot.getZ() / 90.0);
        }
        return slot;
    }

    @Override
    public BaseBlock transformBlock(BaseBlock block, Transform transform) {
        CompoundTag nbt = block.getNbtData();
        if (nbt == null) {
            return block;
        }
        if (!"savedMultipart".equals(nbt.getString("id"))) {
            return block;
        }
        if (!(transform instanceof AffineTransform)) {
            return block;
        }
        AffineTransform affine = (AffineTransform)transform;
        Vector rot = affine.getRotations();
        if (rot.getX() > 0.0) {
            System.out.println("X rotation is currently unsupported");
            rot = rot.setX(0);
        }
        if (rot.getZ() > 0.0) {
            System.out.println("Z rotation is currently unsupported");
            rot = rot.setZ(0);
        }
        if (rot.lengthSq() == 0.0) {
            return block;
        }
        CompoundTagBuilder builder = nbt.createBuilder();
        ArrayList<CompoundTag> parts = new ArrayList<CompoundTag>(nbt.getList("parts", CompoundTag.class));
        for (int i = 0; i < parts.size(); ++i) {
            CompoundTag part = (CompoundTag)parts.get(i);
            String id = part.getString("id");
            byte shape = part.getByte("shape");
            int size = shape >> 4;
            int slot = shape & 0xF;
            switch (id) {
                case "mcr_edge": {
                    slot = this.rotateEdgeSlot(rot, slot);
                    break;
                }
                case "mcr_post": {
                    slot = this.rotatePostSlot(rot, slot);
                    break;
                }
                case "mcr_cnr": {
                    slot = this.rotateCnrSlot(rot, slot);
                    break;
                }
                case "mcr_face": 
                case "mcr_hllw": {
                    slot = this.rotateFaceSlot(rot, slot);
                    break;
                }
            }
            shape = (byte)(size << 4 | slot);
            CompoundTagBuilder partBuilder = part.createBuilder();
            partBuilder.putByte("shape", shape);
            parts.set(i, partBuilder.build());
        }
        builder.put("parts", new ListTag(CompoundTag.class, parts));
        return new BaseBlock(block.getId(), block.getData(), builder.build());
    }
}

