/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.transform;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.math.MathUtils;
import com.sk89q.worldedit.math.transform.CombinedTransform;
import com.sk89q.worldedit.math.transform.Transform;

public class AffineTransform
implements Transform {
    private double m00;
    private double m01;
    private double m02;
    private double m03;
    private double m10;
    private double m11;
    private double m12;
    private double m13;
    private double m20;
    private double m21;
    private double m22;
    private double m23;

    public AffineTransform() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
    }

    public AffineTransform(double[] coefs) {
        if (coefs.length == 9) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
            this.m20 = coefs[6];
            this.m21 = coefs[7];
            this.m22 = coefs[8];
        } else if (coefs.length == 12) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m03 = coefs[3];
            this.m10 = coefs[4];
            this.m11 = coefs[5];
            this.m12 = coefs[6];
            this.m13 = coefs[7];
            this.m20 = coefs[8];
            this.m21 = coefs[9];
            this.m22 = coefs[10];
            this.m23 = coefs[11];
        } else {
            throw new IllegalArgumentException("Input array must have 9 or 12 elements");
        }
    }

    public AffineTransform(double xx, double yx, double zx, double tx, double xy, double yy, double zy, double ty, double xz, double yz, double zz, double tz) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = zx;
        this.m03 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = zy;
        this.m13 = ty;
        this.m20 = xz;
        this.m21 = yz;
        this.m22 = zz;
        this.m23 = tz;
    }

    @Override
    public boolean isIdentity() {
        if (this.m00 != 1.0) {
            return false;
        }
        if (this.m11 != 1.0) {
            return false;
        }
        if (this.m22 != 1.0) {
            return false;
        }
        if (this.m01 != 0.0) {
            return false;
        }
        if (this.m02 != 0.0) {
            return false;
        }
        if (this.m03 != 0.0) {
            return false;
        }
        if (this.m10 != 0.0) {
            return false;
        }
        if (this.m12 != 0.0) {
            return false;
        }
        if (this.m13 != 0.0) {
            return false;
        }
        if (this.m20 != 0.0) {
            return false;
        }
        if (this.m21 != 0.0) {
            return false;
        }
        return this.m23 == 0.0;
    }

    public double[] coefficients() {
        return new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23};
    }

    private double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    @Override
    public AffineTransform inverse() {
        double det = this.determinant();
        return new AffineTransform((this.m11 * this.m22 - this.m21 * this.m12) / det, (this.m21 * this.m01 - this.m01 * this.m22) / det, (this.m01 * this.m12 - this.m11 * this.m02) / det, (this.m01 * (this.m22 * this.m13 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m21 * this.m13) - this.m03 * (this.m11 * this.m22 - this.m21 * this.m12)) / det, (this.m20 * this.m12 - this.m10 * this.m22) / det, (this.m00 * this.m22 - this.m20 * this.m02) / det, (this.m10 * this.m02 - this.m00 * this.m12) / det, (this.m00 * (this.m12 * this.m23 - this.m22 * this.m13) - this.m02 * (this.m10 * this.m23 - this.m20 * this.m13) + this.m03 * (this.m10 * this.m22 - this.m20 * this.m12)) / det, (this.m10 * this.m21 - this.m20 * this.m11) / det, (this.m20 * this.m01 - this.m00 * this.m21) / det, (this.m00 * this.m11 - this.m10 * this.m01) / det, (this.m00 * (this.m21 * this.m13 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m20 * this.m13) - this.m03 * (this.m10 * this.m21 - this.m20 * this.m11)) / det);
    }

    public AffineTransform concatenate(AffineTransform that) {
        double n00 = this.m00 * that.m00 + this.m01 * that.m10 + this.m02 * that.m20;
        double n01 = this.m00 * that.m01 + this.m01 * that.m11 + this.m02 * that.m21;
        double n02 = this.m00 * that.m02 + this.m01 * that.m12 + this.m02 * that.m22;
        double n03 = this.m00 * that.m03 + this.m01 * that.m13 + this.m02 * that.m23 + this.m03;
        double n10 = this.m10 * that.m00 + this.m11 * that.m10 + this.m12 * that.m20;
        double n11 = this.m10 * that.m01 + this.m11 * that.m11 + this.m12 * that.m21;
        double n12 = this.m10 * that.m02 + this.m11 * that.m12 + this.m12 * that.m22;
        double n13 = this.m10 * that.m03 + this.m11 * that.m13 + this.m12 * that.m23 + this.m13;
        double n20 = this.m20 * that.m00 + this.m21 * that.m10 + this.m22 * that.m20;
        double n21 = this.m20 * that.m01 + this.m21 * that.m11 + this.m22 * that.m21;
        double n22 = this.m20 * that.m02 + this.m21 * that.m12 + this.m22 * that.m22;
        double n23 = this.m20 * that.m03 + this.m21 * that.m13 + this.m22 * that.m23 + this.m23;
        return new AffineTransform(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23);
    }

    public AffineTransform preConcatenate(AffineTransform that) {
        double n00 = that.m00 * this.m00 + that.m01 * this.m10 + that.m02 * this.m20;
        double n01 = that.m00 * this.m01 + that.m01 * this.m11 + that.m02 * this.m21;
        double n02 = that.m00 * this.m02 + that.m01 * this.m12 + that.m02 * this.m22;
        double n03 = that.m00 * this.m03 + that.m01 * this.m13 + that.m02 * this.m23 + that.m03;
        double n10 = that.m10 * this.m00 + that.m11 * this.m10 + that.m12 * this.m20;
        double n11 = that.m10 * this.m01 + that.m11 * this.m11 + that.m12 * this.m21;
        double n12 = that.m10 * this.m02 + that.m11 * this.m12 + that.m12 * this.m22;
        double n13 = that.m10 * this.m03 + that.m11 * this.m13 + that.m12 * this.m23 + that.m13;
        double n20 = that.m20 * this.m00 + that.m21 * this.m10 + that.m22 * this.m20;
        double n21 = that.m20 * this.m01 + that.m21 * this.m11 + that.m22 * this.m21;
        double n22 = that.m20 * this.m02 + that.m21 * this.m12 + that.m22 * this.m22;
        double n23 = that.m20 * this.m03 + that.m21 * this.m13 + that.m22 * this.m23 + that.m23;
        return new AffineTransform(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23);
    }

    public AffineTransform translate(Vector vec) {
        return this.translate(vec.getX(), vec.getY(), vec.getZ());
    }

    public AffineTransform translate(double x, double y, double z) {
        return this.concatenate(new AffineTransform(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z));
    }

    public AffineTransform rotateX(double theta) {
        double cot = MathUtils.dCos(theta);
        double sit = MathUtils.dSin(theta);
        return this.concatenate(new AffineTransform(1.0, 0.0, 0.0, 0.0, 0.0, cot, -sit, 0.0, 0.0, sit, cot, 0.0));
    }

    public AffineTransform rotateY(double theta) {
        double cot = MathUtils.dCos(theta);
        double sit = MathUtils.dSin(theta);
        return this.concatenate(new AffineTransform(cot, 0.0, sit, 0.0, 0.0, 1.0, 0.0, 0.0, -sit, 0.0, cot, 0.0));
    }

    public AffineTransform rotateZ(double theta) {
        double cot = MathUtils.dCos(theta);
        double sit = MathUtils.dSin(theta);
        return this.concatenate(new AffineTransform(cot, -sit, 0.0, 0.0, sit, cot, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0));
    }

    public Vector getRotations() {
        double angleZ;
        double angleX;
        double angleY;
        Vector scale = this.getScale();
        if (this.m20 == 1.0) {
            angleY = -1.5707963267948966;
            angleX = Math.atan2(-this.m01 / scale.getX(), -this.m02 / scale.getX());
            angleZ = 0.0;
        } else if (this.m20 == -1.0) {
            angleY = 1.5707963267948966;
            angleX = Math.atan2(this.m01 / scale.getX(), this.m02 / scale.getX());
            angleZ = 0.0;
        } else {
            angleY = -Math.asin(this.m20 / scale.getX());
            angleX = Math.atan2(this.m21 / scale.getY() / Math.cos(angleY), this.m22 / scale.getZ() / Math.cos(angleY));
            angleZ = Math.atan2(this.m10 / scale.getX() / Math.cos(angleY), this.m00 / scale.getX() / Math.cos(angleY));
            double angleY2 = Math.PI - angleY;
            double angleX2 = Math.atan2(this.m21 / Math.cos(angleY2), this.m22 / Math.cos(angleY2));
            double angleZ2 = Math.atan2(this.m10 / Math.cos(angleY2), this.m00 / Math.cos(angleY2));
            Vector vector = new Vector(angleX, angleY, angleZ);
            Vector vector2 = new Vector(angleX2, angleY2, angleZ2);
            if (vector.lengthSq() > vector2.lengthSq()) {
                angleX = angleX2;
                angleY = angleY2;
                angleZ = angleZ2;
            }
        }
        angleX = Math.toDegrees(angleX) % 360.0;
        angleY = Math.toDegrees(angleY) % 360.0;
        angleZ = Math.toDegrees(angleZ) % 360.0;
        if (angleX < 0.0) {
            angleX += 360.0;
        }
        if (angleY < 0.0) {
            angleY += 360.0;
        }
        if (angleZ < 0.0) {
            angleZ += 360.0;
        }
        return new Vector(angleX, angleY, angleZ);
    }

    public AffineTransform scale(double s) {
        return this.scale(s, s, s);
    }

    public AffineTransform scale(double sx, double sy, double sz) {
        return this.concatenate(new AffineTransform(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0));
    }

    public AffineTransform scale(Vector vec) {
        return this.scale(vec.getX(), vec.getY(), vec.getZ());
    }

    public Vector getScale() {
        double scaleX = Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
        double scaleY = Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        double scaleZ = Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
        return new Vector(scaleX, scaleY, scaleZ);
    }

    @Override
    public Vector apply(Vector vector) {
        return new Vector(vector.getX() * this.m00 + vector.getY() * this.m01 + vector.getZ() * this.m02 + this.m03, vector.getX() * this.m10 + vector.getY() * this.m11 + vector.getZ() * this.m12 + this.m13, vector.getX() * this.m20 + vector.getY() * this.m21 + vector.getZ() * this.m22 + this.m23);
    }

    public AffineTransform combine(AffineTransform other) {
        return this.concatenate(other);
    }

    @Override
    public Transform combine(Transform other) {
        if (other instanceof AffineTransform) {
            return this.concatenate((AffineTransform)other);
        }
        return new CombinedTransform(this, other);
    }

    public String toString() {
        return String.format("Affine[%g %g %g %g, %g %g %g %g, %g %g %g %g]", this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23);
    }
}

