/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slprime.chromatictooltips.ClientProxy;
import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipRenderer;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.SectionComponent;
import com.slprime.chromatictooltips.component.SpaceComponent;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.config.GeneralConfig;
import com.slprime.chromatictooltips.event.RenderTooltipEvent;
import com.slprime.chromatictooltips.util.ItemStackFilterParser;
import com.slprime.chromatictooltips.util.SectionBox;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipSpacing;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TooltipRenderer
implements ITooltipRenderer {
    protected Map<String, SectionBox> sectionBoxCache = new HashMap<String, SectionBox>();
    protected Map<String, SpaceComponent> spacingCache = new HashMap<String, SpaceComponent>();
    protected Map<String, EnumSet<TooltipModifier>> tooltipModifierCache = new HashMap<String, EnumSet<TooltipModifier>>();
    protected Map<String, EnricherPlace> enricherPlaceCache = new HashMap<String, EnricherPlace>();
    protected int mainAxisOffset = 6;
    protected int crossAxisOffset = -18;
    protected int maxWidth = Integer.MAX_VALUE;
    protected SectionBox navigationBox = null;
    protected SectionBox tooltipBox;
    protected Predicate<TooltipTarget> filter;
    protected TooltipStyle tooltipStyle;

    public TooltipRenderer(TooltipStyle style) {
        this.filter = ItemStackFilterParser.parse(style.getAsString("filter", ""));
        this.maxWidth = style.getAsInt("maxWidth", this.maxWidth);
        this.navigationBox = new SectionBox(style.getAsStyle("navigation"));
        this.tooltipBox = new SectionBox(style);
        this.tooltipStyle = style;
        if (!style.containsKey("divider")) {
            this.spacingCache.put("divider", new SpaceComponent(new TooltipStyle(this.createDefaultDivider())));
        }
        int[] offset = style.getAsProperty("offset", new String[][]{{"main"}, {"cross"}}, new int[]{this.mainAxisOffset, this.crossAxisOffset});
        this.mainAxisOffset = offset[0];
        this.crossAxisOffset = offset[1];
        this.generateEnricherCaches();
    }

    @Override
    public int getMainAxisOffset() {
        return this.mainAxisOffset;
    }

    @Override
    public int getCrossAxisOffset() {
        return this.crossAxisOffset;
    }

    protected JsonObject createDefaultDivider() {
        JsonObject dividerStyle = new JsonObject();
        JsonObject decorator = new JsonObject();
        decorator.addProperty("type", "background");
        decorator.addProperty("color", "0xFFFFFFFF");
        decorator.addProperty("alignBlock", "center");
        decorator.addProperty("height", (Number)1);
        dividerStyle.add("decorator", (JsonElement)decorator);
        dividerStyle.addProperty("height", (Number)10);
        return dividerStyle;
    }

    protected void generateEnricherCaches() {
        JsonObject sections = this.tooltipStyle.getAsJsonObject("sections", new JsonObject());
        for (Map.Entry entry : sections.entrySet()) {
            if (entry.getValue() == null || !((JsonElement)entry.getValue()).isJsonObject()) continue;
            String sectionId = (String)entry.getKey();
            JsonObject section = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (section.has("modes")) {
                EnumSet<TooltipModifier> values = EnumSet.noneOf(TooltipModifier.class);
                for (JsonElement modeElement : section.getAsJsonArray("modes")) {
                    String mode = modeElement.getAsString();
                    if (mode == null || mode.isEmpty()) continue;
                    values.add(TooltipModifier.fromString(mode));
                }
                this.tooltipModifierCache.put(sectionId, values);
            }
            if (!section.has("place")) continue;
            this.enricherPlaceCache.put(sectionId, EnricherPlace.fromString(section.get("place").getAsString()));
        }
    }

    @Override
    public boolean matches(TooltipTarget target) {
        return this.filter == null || this.filter.test(target);
    }

    @Override
    public TooltipStyle getStyle() {
        return this.tooltipStyle;
    }

    @Override
    public EnumSet<TooltipModifier> getEnricherModes(String enricherId, EnumSet<TooltipModifier> defaultModes) {
        return this.tooltipModifierCache.getOrDefault(enricherId, defaultModes);
    }

    @Override
    public EnricherPlace getEnricherPlace(String enricherId, EnricherPlace defaultPlace) {
        return this.enricherPlaceCache.getOrDefault(enricherId, defaultPlace);
    }

    @Override
    public SectionBox getSectionBox(String path) {
        return this.sectionBoxCache.computeIfAbsent(path, p -> new SectionBox(this.tooltipStyle.getAsStyle((String)p)));
    }

    @Override
    public SpaceComponent getSpacing(String path) {
        return this.spacingCache.computeIfAbsent(path, p -> new SpaceComponent(this.tooltipStyle.getAsStyle((String)p)));
    }

    protected List<ITooltipComponent> prepareComponents(List<SectionComponent> components) {
        ArrayList<ITooltipComponent> result = new ArrayList<ITooltipComponent>(components);
        if (result.size() > 1 && this.getSpacing("hr").getHeight() > 0) {
            result.add(1, this.getSpacing("hr"));
        }
        return result;
    }

    protected List<SectionComponent> paginateComponents(TooltipContext context, SectionComponent component, int maxWidth, int maxHeight) {
        maxWidth = Math.max(Math.min(GeneralConfig.maxWidth == 0 ? this.maxWidth : Math.max(50, GeneralConfig.maxWidth), maxWidth), this.tooltipBox.getMinWidth());
        maxHeight = Math.max(maxHeight, this.tooltipBox.getMinHeight());
        ArrayList<SectionComponent> pages = new ArrayList<SectionComponent>();
        int paginationHeight = this.navigationBox.getBlock() + TooltipFontContext.getFontHeight() - 2;
        ITooltipComponent[] split = component.paginate(context, maxWidth, maxHeight);
        SectionComponent firstPage = (SectionComponent)split[0];
        if (split.length == 1) {
            return Collections.singletonList(firstPage);
        }
        maxHeight = Math.max(0, maxHeight - paginationHeight);
        while (component != null) {
            split = component.paginate(context, maxWidth, maxHeight);
            pages.add((SectionComponent)split[0]);
            if (split.length > 1) {
                component = (SectionComponent)split[1];
                continue;
            }
            component = null;
        }
        return pages;
    }

    protected void addNavigation(SectionComponent component, int currentPage, int totalPages) {
        int nextKeyCode = ClientProxy.nextPage.func_151463_i();
        int previousKeyCode = ClientProxy.previousPage.func_151463_i();
        String nextKey = nextKeyCode != 0 ? Keyboard.getKeyName((int)nextKeyCode) : "";
        String previousKey = previousKeyCode != 0 ? Keyboard.getKeyName((int)previousKeyCode) : "";
        String text = "";
        if (!nextKey.isEmpty() && !previousKey.isEmpty()) {
            text = TooltipUtils.translate("navigation.page", currentPage, totalPages, nextKey, previousKey);
        } else if (!nextKey.isEmpty()) {
            text = TooltipUtils.translate("navigation.page.next_only", currentPage, totalPages, nextKey);
        } else if (!previousKey.isEmpty()) {
            text = TooltipUtils.translate("navigation.page.previous_only", currentPage, totalPages, previousKey);
        }
        if (!text.isEmpty()) {
            component.clearPendingComponent();
            component.addComponent(new SectionComponent("navigation", this.navigationBox, Collections.singletonList(new TextComponent(text))));
        }
    }

    @Override
    public List<SectionComponent> paginateTooltip(TooltipContext context) {
        SectionComponent section = new SectionComponent("page", this.tooltipBox, this.prepareComponents(context.getSections()));
        int scaleFactor = context.getScaleFactor();
        Dimension freeSpace = this.getFreeSpace(scaleFactor);
        List<SectionComponent> pagedComponents = this.paginateComponents(context, section, freeSpace.width, freeSpace.height);
        if (pagedComponents.size() > 1) {
            for (int i = 0; i < pagedComponents.size(); ++i) {
                this.addNavigation(pagedComponents.get(i), i + 1, pagedComponents.size());
            }
        }
        return pagedComponents;
    }

    protected Dimension getFreeSpace(int scaleFactor) {
        Minecraft mc = TooltipUtils.mc();
        return new Dimension((int)Math.ceil((float)mc.field_71443_c / (float)scaleFactor), (int)Math.ceil((float)mc.field_71440_d / (float)scaleFactor));
    }

    @Override
    public void draw(TooltipContext context, int x, int y) {
        SectionComponent section = context.getActivePageComponent();
        if (section != null && !section.isEmpty()) {
            TooltipSpacing margin = section.getMargin();
            int width = section.getWidth() - margin.getInline();
            int height = section.getHeight() - margin.getBlock();
            float scaleShift = (float)context.getScaleFactor() / (float)TooltipUtils.getScaledResolution().func_78325_e();
            Rectangle tooltipRectangle = new Rectangle(x + (int)((float)margin.getLeft() * scaleShift), y + (int)((float)margin.getTop() * scaleShift), (int)((float)width * scaleShift), (int)((float)height * scaleShift));
            this.drawContent(context, section, scaleShift, x, y);
            TooltipUtils.postEvent(new RenderTooltipEvent(context, section, tooltipRectangle));
        }
    }

    protected void drawContent(TooltipContext context, SectionComponent section, float scaleShift, int x, int y) {
        GL11.glPushMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        TooltipUtils.incZLevel(150.0f);
        if (scaleShift != 1.0f) {
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)scaleShift, (float)scaleShift, (float)scaleShift);
            section.draw(0, 0, section.getWidth(), context);
            GL11.glScalef((float)(1.0f / scaleShift), (float)(1.0f / scaleShift), (float)(1.0f / scaleShift));
        } else {
            section.draw(x, y, section.getWidth(), context);
        }
        TooltipUtils.incZLevel(-150.0f);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }
}

