/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.api;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.component.ItemAttributeComponent;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.util.NumberFormat;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ItemStats {
    protected static final UUID ITEM_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected String textLine;
    protected String iconLine;
    protected double value;
    protected String icon;

    public ItemStats(String textLine, String iconLine, double value, String icon) {
        this.textLine = textLine;
        this.iconLine = iconLine;
        this.value = value;
        this.icon = icon;
    }

    public ItemStats(String attributeName, double value, StatsOperator operator, String icon) {
        String attributeValue = NumberFormat.formatWithCommas(Math.abs(value));
        String dir = value >= 0.0 ? "plus" : "minus";
        this.textLine = TooltipUtils.translate("enricher.attributes." + operator.getKey() + ".text." + dir, attributeValue, attributeName);
        this.iconLine = TooltipUtils.translate("enricher.attributes." + operator.getKey() + ".icon." + dir, attributeValue);
        this.value = value;
        this.icon = icon;
    }

    public ItemStats withIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public double getValue() {
        return this.value;
    }

    public int getOrder() {
        return (int)(100.0 * this.value);
    }

    public static double getModifiedAmount(AttributeModifier modifier, ItemStack stack) {
        double amount = modifier.func_111164_d();
        if (modifier.func_111167_a() == ITEM_UUID) {
            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
        }
        if (modifier.func_111169_c() != 0) {
            amount *= 100.0;
        }
        return amount;
    }

    public ITooltipComponent getIconComponent() {
        if (this.icon != null && this.iconLine != null) {
            return new ItemAttributeComponent(this.icon, this.iconLine);
        }
        return null;
    }

    public ITooltipComponent getTextComponent() {
        return this.textLine != null ? new TextComponent(TooltipUtils.applyBaseColorIfAbsent(this.textLine, TooltipLines.BASE_COLOR)) : null;
    }

    public String getTextLine() {
        return this.textLine;
    }

    public static enum StatsOperator {
        ADDITION(0, "addition"),
        MULTIPLY_BASE(1, "percent"),
        MULTIPLY_TOTAL(2, "percent");

        private final int operation;
        private final String key;

        private StatsOperator(int operation, String key) {
            this.operation = operation;
            this.key = key;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getKey() {
            return this.key;
        }

        public static StatsOperator fromOperation(int operation) {
            for (StatsOperator op : StatsOperator.values()) {
                if (op.getOperation() != operation) continue;
                return op;
            }
            return null;
        }
    }

    public static class BurnTimeStats
    extends ItemStats {
        public BurnTimeStats(int burnTime) {
            super(TooltipUtils.translate("enricher.attributes.fuel.text", NumberFormat.formatWithCommas(burnTime)), TooltipUtils.translate("enricher.attributes.fuel.icon", NumberFormat.formatWithCommas(burnTime)), burnTime, "attributes/fuel.png");
        }
    }

    public static class DurabilityStats
    extends ItemStats {
        public DurabilityStats(int durability, int maxDurability) {
            super(TooltipUtils.translate("enricher.attributes.durability.text", NumberFormat.formatWithCommas(durability), NumberFormat.formatWithCommas(maxDurability)), TooltipUtils.translate("enricher.attributes.durability.icon", NumberFormat.formatWithCommas(durability), NumberFormat.formatWithCommas(maxDurability)), durability, "attributes/durability.png");
        }

        @Override
        public int getOrder() {
            return -10010;
        }
    }

    public static class UnbreakableStats
    extends ItemStats {
        public UnbreakableStats() {
            super(StatCollector.func_74838_a((String)"item.unbreakable"), null, 0.0, null);
        }

        @Override
        public int getOrder() {
            return -10000;
        }
    }

    public static class MovementSpeedStats
    extends ItemStats {
        public MovementSpeedStats(double movementSpeed) {
            super(StatCollector.func_74838_a((String)"attribute.name.generic.movementSpeed"), movementSpeed, StatsOperator.ADDITION, "attributes/movement_speed.png");
        }
    }

    public static class KnockbackResistanceStats
    extends ItemStats {
        public KnockbackResistanceStats(double knockbackResistance) {
            super(StatCollector.func_74838_a((String)"attribute.name.generic.knockbackResistance"), knockbackResistance, StatsOperator.ADDITION, "attributes/knockback_resistance.png");
        }
    }

    public static class MaxHealthStats
    extends ItemStats {
        public MaxHealthStats(double maxHealth) {
            super(StatCollector.func_74838_a((String)"attribute.name.generic.maxHealth"), maxHealth, StatsOperator.ADDITION, "attributes/max_health.png");
        }
    }

    public static class AttackDamageStats
    extends ItemStats {
        public AttackDamageStats(double attackDamage) {
            super(StatCollector.func_74838_a((String)"attribute.name.generic.attackDamage"), attackDamage, StatsOperator.ADDITION, "attributes/attack_damage.png");
        }
    }

    public static class ArmorStats
    extends ItemStats {
        public ArmorStats(int damageReduceAmount) {
            super(TooltipUtils.translate("enricher.attributes.armor.text", NumberFormat.formatWithCommas(damageReduceAmount)), TooltipUtils.translate("enricher.attributes.armor.icon", NumberFormat.formatWithCommas(damageReduceAmount)), damageReduceAmount, "attributes/armor.png");
        }
    }
}

