/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.api;

import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipTarget;
import java.awt.Point;
import net.minecraft.item.ItemStack;

public class TooltipRequest {
    public final String context;
    public final TooltipTarget target;
    public final TooltipLines tooltip;
    public final Point mouse;

    public TooltipRequest(String context, TooltipTarget target, TooltipLines tooltip, Point mouse) {
        this.context = context;
        this.target = target;
        this.tooltip = tooltip != null ? tooltip : new TooltipLines();
        this.mouse = mouse;
    }

    public TooltipRequest(TooltipRequest request) {
        this(request.context, request.target, new TooltipLines(request.tooltip), request.mouse);
    }

    public TooltipRequest(TooltipRequest request, TooltipTarget target) {
        this(request.context, target, new TooltipLines(request.tooltip), request.mouse);
    }

    public TooltipRequest copy() {
        return new TooltipRequest(this);
    }

    public boolean sameSubjectAs(TooltipRequest other) {
        if (other == null || !this.sameSubjectPresence(other)) {
            return false;
        }
        if (this.target.isFluid() && !this.target.getFluid().isFluidEqual(other.target.getFluid())) {
            return false;
        }
        return !this.target.isItem() || TooltipRequest.areStacksSameType(this.target.getItem(), other.target.getItem());
    }

    public boolean equivalentTo(TooltipRequest other) {
        if (!this.sameSubjectAs(other)) {
            return false;
        }
        if (this.target.getStackAmount() != other.target.getStackAmount()) {
            return false;
        }
        return this.target.equivalentTo(other.target) && this.tooltip.equals(other.tooltip);
    }

    private boolean sameSubjectPresence(TooltipRequest other) {
        return this.target.isItem() == other.target.isItem() && this.target.isFluid() == other.target.isFluid();
    }

    protected static boolean areStacksSameType(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA == null || stackB == null) {
            return false;
        }
        return stackA.func_77973_b() == stackB.func_77973_b() && (stackA.func_77960_j() == stackB.func_77960_j() || stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || stackA.func_77973_b().func_77645_m());
    }
}

