/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.api;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TooltipTarget {
    public static final TooltipTarget EMPTY = new TooltipTarget(null, null, 0L, null, 0L);
    private ItemStack item;
    private FluidStack fluid;
    private long stackAmount;
    private Fluid containedFluid;
    private long containedFluidAmount;

    private TooltipTarget(ItemStack item, FluidStack fluid, long stackAmount, Fluid containedFluid, long containedFluidAmount) {
        this.item = item != null ? item.func_77946_l() : null;
        this.fluid = fluid != null ? fluid.copy() : null;
        this.stackAmount = stackAmount;
        this.containedFluid = containedFluid;
        this.containedFluidAmount = containedFluidAmount;
    }

    public static TooltipTarget ofItem(ItemStack item, long stackAmount) {
        if (item == null) {
            return EMPTY;
        }
        FluidStack fluid = TooltipTarget.getFluid(item);
        if (fluid != null) {
            return new TooltipTarget(item, null, stackAmount, fluid.getFluid(), fluid.amount);
        }
        return new TooltipTarget(item, null, stackAmount, null, 0L);
    }

    public static TooltipTarget ofItem(ItemStack item) {
        if (item == null) {
            return EMPTY;
        }
        return TooltipTarget.ofItem(item, item.field_77994_a);
    }

    public static TooltipTarget ofFluid(FluidStack fluid, long stackAmount) {
        if (fluid == null) {
            return EMPTY;
        }
        return new TooltipTarget(null, fluid, stackAmount, null, 0L);
    }

    public static TooltipTarget ofFluid(FluidStack fluid) {
        if (fluid == null) {
            return EMPTY;
        }
        return TooltipTarget.ofFluid(fluid, fluid.amount);
    }

    public TooltipTarget withContainedFluid(Fluid fluid, long amount) {
        return new TooltipTarget(this.item, this.fluid, this.stackAmount, fluid, amount);
    }

    public TooltipTarget withContainedFluid(FluidStack fluid) {
        return new TooltipTarget(this.item, this.fluid, this.stackAmount, fluid.getFluid(), fluid.amount);
    }

    public TooltipTarget withStackAmount(long amount) {
        if (this.stackAmount == amount) {
            return this;
        }
        return new TooltipTarget(this.item, this.fluid, amount, this.containedFluid, this.containedFluidAmount);
    }

    public long getStackAmount() {
        return this.stackAmount;
    }

    public Fluid getContainedFluid() {
        return this.containedFluid;
    }

    public long getContainedFluidAmount() {
        return this.containedFluidAmount;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public boolean isItem() {
        return this.item != null;
    }

    public boolean isFluidContainer() {
        return this.item != null && this.containedFluid != null;
    }

    public boolean isFluid() {
        return this.item == null && this.fluid != null;
    }

    protected static FluidStack getFluid(ItemStack stack) {
        Item item;
        if (stack == null) {
            return null;
        }
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fluidStack == null && (item = stack.func_77973_b()) instanceof IFluidContainerItem) {
            IFluidContainerItem fluidItem = (IFluidContainerItem)item;
            fluidStack = fluidItem.getFluid(stack);
        }
        return fluidStack;
    }

    public boolean equivalentTo(TooltipTarget other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.item != null || other.item != null) {
            if (this.item == null || other.item == null) {
                return false;
            }
            return TooltipTarget.isItemEqualWithNBT(this.item, other.item);
        }
        if (this.fluid != null || other.fluid != null) {
            if (this.fluid == null || other.fluid == null) {
                return false;
            }
            return this.fluid.isFluidEqual(other.fluid);
        }
        return true;
    }

    protected static boolean isItemEqualWithNBT(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA == null || stackB == null || !stackA.func_77969_a(stackB)) {
            return false;
        }
        if (stackA.func_77942_o() && stackB.func_77942_o()) {
            return stackA.field_77990_d.equals((Object)stackB.field_77990_d);
        }
        return !(stackA.field_77990_d != null && !stackA.field_77990_d.func_82582_d() || stackB.field_77990_d != null && !stackB.field_77990_d.func_82582_d());
    }
}

