/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import java.util.ArrayList;
import java.util.List;
import org.joml.Math;

public class InlineComponent
implements ITooltipComponent {
    protected List<List<ITooltipComponent>> lines;
    protected int inlineGap = 0;
    protected int blockGap = 0;

    public InlineComponent(List<List<ITooltipComponent>> lines, int inlineGap, int blockGap) {
        this.lines = lines;
        this.inlineGap = inlineGap;
        this.blockGap = blockGap;
    }

    protected List<List<ITooltipComponent>> generateLines(List<List<ITooltipComponent>> rawLines, int maxWidth) {
        ArrayList<List<ITooltipComponent>> lines = new ArrayList<List<ITooltipComponent>>();
        ArrayList<ITooltipComponent> currentLine = new ArrayList<ITooltipComponent>();
        int lineWidth = 0;
        for (List<ITooltipComponent> rawLine : rawLines) {
            for (ITooltipComponent component : rawLine) {
                if (lineWidth > 0 && lineWidth + component.getWidth() > maxWidth) {
                    lines.add(currentLine);
                    currentLine = new ArrayList();
                    lineWidth = 0;
                }
                lineWidth += component.getWidth() + this.inlineGap;
                currentLine.add(component);
            }
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (List<ITooltipComponent> line : this.lines) {
            int lineWidth = -this.inlineGap;
            for (ITooltipComponent component : line) {
                lineWidth += component.getWidth() + this.inlineGap;
            }
            width = Math.max((int)width, (int)lineWidth);
        }
        return width;
    }

    @Override
    public int getHeight() {
        int height = 0;
        int lastSpacing = 0;
        for (List<ITooltipComponent> line : this.lines) {
            int lineSpacing = 0;
            int lineHeight = 0;
            for (ITooltipComponent component : line) {
                lineHeight = Math.max((int)lineHeight, (int)component.getHeight());
                lineSpacing = Math.max((int)lineSpacing, (int)component.getSpacing());
            }
            height += lineHeight + lastSpacing;
            lastSpacing = this.blockGap + lineSpacing;
        }
        return Math.max((int)0, (int)height);
    }

    @Override
    public int getSpacing() {
        return 2;
    }

    @Override
    public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
        ArrayList<List<ITooltipComponent>> firstComponent = new ArrayList<List<ITooltipComponent>>();
        ArrayList<List<ITooltipComponent>> secondComponent = new ArrayList<List<ITooltipComponent>>();
        int height = 0;
        int lastSpacing = 0;
        for (List<ITooltipComponent> line : this.generateLines(this.lines, maxWidth)) {
            int lineSpacing = 0;
            int lineHeight = 0;
            for (ITooltipComponent component : line) {
                lineHeight = Math.max((int)lineHeight, (int)component.getHeight());
                lineSpacing = Math.max((int)lineSpacing, (int)component.getSpacing());
            }
            if (height + lineHeight + lastSpacing > maxHeight && !firstComponent.isEmpty()) {
                secondComponent.add(line);
            } else {
                firstComponent.add(line);
            }
            height += lineHeight + lastSpacing;
            lastSpacing = this.blockGap + lineSpacing;
        }
        if (secondComponent.isEmpty()) {
            return new ITooltipComponent[]{new InlineComponent(firstComponent, this.inlineGap, this.blockGap)};
        }
        return new ITooltipComponent[]{new InlineComponent(firstComponent, this.inlineGap, this.blockGap), new InlineComponent(secondComponent, this.inlineGap, this.blockGap)};
    }

    @Override
    public void draw(int x, int y, int availableWidth, TooltipContext context) {
        int height = 0;
        for (List<ITooltipComponent> line : this.lines) {
            int lineWidth = 0;
            int lineSpacing = 0;
            int lineHeight = 0;
            for (ITooltipComponent component : line) {
                component.draw(x + lineWidth, y + height, availableWidth - lineWidth, context);
                lineWidth += component.getWidth() + this.inlineGap;
                lineHeight = Math.max((int)lineHeight, (int)component.getHeight());
                lineSpacing = Math.max((int)lineSpacing, (int)component.getSpacing());
            }
            height += lineHeight + this.blockGap + lineSpacing;
        }
    }

    public int hashCode() {
        return this.lines.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InlineComponent) {
            InlineComponent other = (InlineComponent)obj;
            return this.lines.equals(other.lines);
        }
        return false;
    }
}

