/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.converter;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipLineConverter;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.component.DividerComponent;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DividerConverter
implements ITooltipLineConverter {
    public static final Pattern PATTERN = Pattern.compile("^(\\s*)(?:\u00a7[0-9a-fk-or])*\u00a7([0-9a-f])(?:\u00a7[0-9a-fk-or])*-{3,}(?:\u00a7r)?$", 2);

    @Override
    public ITooltipComponent convert(Matcher matcher, TooltipContext context) {
        if (matcher.matches()) {
            String colorCode = matcher.group(2);
            int colorCodeIndex = "0123456789abcdef".indexOf(colorCode.toLowerCase());
            int marginLeft = TooltipFontContext.getStringWidth(matcher.group(1));
            return new DividerComponent(context.getRenderer().getSpacing("divider"), marginLeft, colorCodeIndex);
        }
        return null;
    }
}

