/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.event.FluidInfoEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidInfoEnricher
implements ITooltipEnricher {
    private static final ItemStack glassBottle = new ItemStack(Items.field_151069_bo, 1);

    @Override
    public String sectionId() {
        return "fluidInfo";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.NONE, TooltipModifier.SHIFT);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!context.getTarget().isFluid()) {
            return null;
        }
        return new TooltipLines(FluidInfoEnricher.getFluidInformation(context.getTarget()));
    }

    public static List<Object> getFluidInformation(TooltipTarget target) {
        ArrayList tooltip = new ArrayList();
        FluidStack fluidStack = target.getFluid();
        ItemStack potion = FluidInfoEnricher.getPotion(fluidStack);
        if (potion != null && potion.func_77973_b() instanceof ItemPotion) {
            potion.func_77973_b().func_77624_a(potion, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltip, false);
        }
        FluidInfoEnricherEvent event = new FluidInfoEnricherEvent(target, tooltip);
        TooltipUtils.postEvent(event);
        return event.tooltip;
    }

    protected static ItemStack getPotion(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        ItemStack fillStack = FluidInfoEnricher.fillStack(glassBottle, fluidStack);
        if (fillStack != null && fillStack.func_77973_b() instanceof ItemPotion) {
            return fillStack;
        }
        return null;
    }

    protected static ItemStack fillStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null || itemStack.field_77994_a != 1) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item;
            container.fill(itemStack, fluid, true);
            return itemStack;
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            return FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)itemStack);
        }
        return null;
    }
}

