/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.event.HotkeyEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HotkeyEnricher
implements ITooltipEnricher {
    @Override
    public String sectionId() {
        return "hotkeys";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.ALT);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!EnricherConfig.hotkeysEnabled) {
            return null;
        }
        return new TooltipLines(this.hotkeysListComponent(context.getTarget()));
    }

    protected TextComponent hotkeysListComponent(TooltipTarget target) {
        HotkeyEnricherEvent event = new HotkeyEnricherEvent(target, new HashMap<String, String>());
        TooltipUtils.postEvent(event);
        event.hotkeys.remove(null);
        event.hotkeys.remove("");
        if (!event.hotkeys.isEmpty()) {
            return new TextComponent(this.getHotkeyList(event.hotkeys));
        }
        return null;
    }

    protected List<String> getHotkeyList(Map<String, String> hotkeys) {
        HashMap<String, List> messages = new HashMap<String, List>();
        for (Map.Entry<String, String> entry2 : hotkeys.entrySet()) {
            messages.computeIfAbsent(entry2.getValue(), m -> new ArrayList()).add(entry2.getKey());
        }
        for (List keys : messages.values()) {
            Collections.sort(keys, (a, b) -> {
                if (a.length() != b.length()) {
                    return Integer.compare(a.length(), b.length());
                }
                return a.compareTo((String)b);
            });
        }
        return messages.entrySet().stream().sorted((a, b) -> {
            String sa = String.join((CharSequence)"/", (Iterable)a.getValue());
            String sb = String.join((CharSequence)"/", (Iterable)b.getValue());
            if (sa.length() != sb.length()) {
                return Integer.compare(sa.length(), sb.length());
            }
            return sa.compareTo(sb);
        }).map(entry -> this.getHotkeyTip((List)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    protected String getHotkeyTip(List<String> keys, String message) {
        return TooltipUtils.translate("enricher.hotkeys.keybind.entry", String.join((CharSequence)TooltipUtils.translate("enricher.hotkeys.keybind.keys", new Object[0]), keys), message);
    }
}

