/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.event.ItemInfoEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemInfoEnricher
implements ITooltipEnricher {
    @Override
    public String sectionId() {
        return "itemInfo";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.NONE, TooltipModifier.SHIFT);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!context.getTarget().isItem()) {
            return null;
        }
        return new TooltipLines(ItemInfoEnricher.getItemInformation(context.getTarget()));
    }

    public static List<Object> getItemInformation(TooltipTarget target) {
        Minecraft mc = TooltipUtils.mc();
        ArrayList<String> tooltip = new ArrayList<String>();
        ItemStack stack = target.getItem().func_77946_l();
        String displayName = stack.func_82833_r();
        tooltip.add(displayName);
        try {
            stack.func_77973_b().func_77624_a(stack, (EntityPlayer)mc.field_71439_g, tooltip, mc.field_71474_y.field_82882_x);
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10)) {
                ItemInfoEnricher.addItemColorAndLore(stack, tooltip, mc.field_71474_y.field_82882_x);
            }
            ForgeEventFactory.onItemTooltip((ItemStack)stack, (EntityPlayer)mc.field_71439_g, tooltip, (boolean)mc.field_71474_y.field_82882_x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!tooltip.isEmpty()) {
            tooltip.remove(0);
        }
        ItemInfoEnricherEvent event = new ItemInfoEnricherEvent(target, tooltip);
        TooltipUtils.postEvent(event);
        return event.tooltip;
    }

    protected static void addItemColorAndLore(ItemStack stack, List<String> arraylist, boolean advancedItemTooltips) {
        NBTTagCompound nbttagcompound = stack.func_77978_p().func_74775_l("display");
        if (nbttagcompound.func_150297_b("color", 3)) {
            if (advancedItemTooltips) {
                arraylist.add("Color: #" + Integer.toHexString(nbttagcompound.func_74762_e("color")).toUpperCase());
            } else {
                arraylist.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.dyed"));
            }
        }
        if (nbttagcompound.func_150299_b("Lore") == 9) {
            NBTTagList nbttaglist1 = nbttagcompound.func_150295_c("Lore", 8);
            for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                arraylist.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + nbttaglist1.func_150307_f(j));
            }
        }
    }
}

