/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.ItemStats;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.InlineComponent;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.event.AttributeEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;

public class ItemStatsEnricher
implements ITooltipEnricher {
    protected static final int PADDING = 4;
    protected static final String SECTION_ID = "stats";
    protected boolean showOnlyIcons = false;

    public ItemStatsEnricher(boolean showOnlyIcons) {
        this.showOnlyIcons = showOnlyIcons;
    }

    @Override
    public String sectionId() {
        return SECTION_ID + (this.showOnlyIcons ? ":icons" : "");
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return this.showOnlyIcons ? EnumSet.of(TooltipModifier.NONE) : EnumSet.of(TooltipModifier.NONE, TooltipModifier.SHIFT);
    }

    protected boolean shownIcons(TooltipContext context) {
        return EnricherConfig.attributeModifierIconsEnabled && context.getRenderer().getEnricherModes("stats:icons", EnumSet.of(TooltipModifier.NONE)).contains((Object)context.getActiveModifier());
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!context.getTarget().isItem() || this.showOnlyIcons && !EnricherConfig.attributeModifierIconsEnabled) {
            return null;
        }
        boolean shownIcons = !this.showOnlyIcons && this.shownIcons(context);
        List<ItemStats> attributeModifiers = ItemStatsEnricher.getAttributeModifiers(context.getTarget());
        ArrayList<ITooltipComponent> attributeModifiersList = new ArrayList<ITooltipComponent>();
        for (ItemStats attributeData : attributeModifiers) {
            if (this.showOnlyIcons && attributeData.hasIcon()) {
                attributeModifiersList.add(attributeData.getIconComponent());
                continue;
            }
            if (this.showOnlyIcons || shownIcons && attributeData.hasIcon()) continue;
            attributeModifiersList.add(attributeData.getTextComponent());
        }
        if (this.showOnlyIcons && !attributeModifiersList.isEmpty()) {
            return new TooltipLines(new InlineComponent(Collections.singletonList(attributeModifiersList), 4, 0));
        }
        return new TooltipLines(attributeModifiersList);
    }

    public static List<ItemStats> getAttributeModifiers(TooltipTarget target) {
        ItemStack stack = target.getItem();
        ArrayList<ItemStats> stats = new ArrayList<ItemStats>();
        for (Map.Entry entry : stack.func_111283_C().entries()) {
            if ("generic.attackDamage".equals(entry.getKey())) {
                stats.add(new ItemStats.AttackDamageStats(ItemStats.getModifiedAmount((AttributeModifier)entry.getValue(), stack)));
                continue;
            }
            if ("generic.maxHealth".equals(entry.getKey())) {
                stats.add(new ItemStats.MaxHealthStats(ItemStats.getModifiedAmount((AttributeModifier)entry.getValue(), stack)));
                continue;
            }
            if ("generic.knockbackResistance".equals(entry.getKey())) {
                stats.add(new ItemStats.KnockbackResistanceStats(ItemStats.getModifiedAmount((AttributeModifier)entry.getValue(), stack)));
                continue;
            }
            if ("generic.movementSpeed".equals(entry.getKey())) {
                stats.add(new ItemStats.MovementSpeedStats(ItemStats.getModifiedAmount((AttributeModifier)entry.getValue(), stack)));
                continue;
            }
            String attributeName = StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()));
            double modifiedAmount = ItemStats.getModifiedAmount((AttributeModifier)entry.getValue(), stack);
            stats.add(new ItemStats(attributeName, modifiedAmount, ItemStats.StatsOperator.fromOperation(((AttributeModifier)entry.getValue()).func_111169_c()), null));
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)item;
            stats.add(new ItemStats.ArmorStats(armor.field_77879_b));
        }
        ItemStatsEnricher.addUnbreakableAttribute(stack, stats);
        if (EnricherConfig.durabilityEnabled) {
            ItemStatsEnricher.addDurabilityAttribute(stack, stats);
        }
        if (EnricherConfig.burnTimeEnabled) {
            ItemStatsEnricher.addBurnTimeAttribute(stack, stats);
        }
        AttributeEnricherEvent event = new AttributeEnricherEvent(target, stats);
        TooltipUtils.postEvent(event);
        Collections.sort(event.stats, (a, b) -> Double.compare(b.getOrder(), a.getOrder()));
        return event.stats;
    }

    private static void addUnbreakableAttribute(ItemStack stack, List<ItemStats> stats) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable")) {
            stats.add(new ItemStats.UnbreakableStats());
        }
    }

    private static void addDurabilityAttribute(ItemStack stack, List<ItemStats> stats) {
        if (stack.func_77984_f() && !stack.func_77981_g() && !stack.func_77985_e()) {
            int maxDurability = stack.func_77958_k();
            int durability = maxDurability - stack.func_77960_j();
            stats.add(new ItemStats.DurabilityStats(durability, maxDurability));
        }
    }

    private static void addBurnTimeAttribute(ItemStack stack, List<ItemStats> stats) {
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burnTime > 0) {
            stats.add(new ItemStats.BurnTimeStats(burnTime));
        }
    }
}

