/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.event.ModInfoEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModInfoEnricher
implements ITooltipEnricher {
    protected static final String DEFAULT_MOD_NAME = "Minecraft";
    protected static final GameRegistry.UniqueIdentifier UNKNOWN_IDENTIFIER = new GameRegistry.UniqueIdentifier("Unknown:unknown");
    protected static volatile Map<String, ModContainer> namedMods = null;

    @Override
    public String sectionId() {
        return "modInfo";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.FOOTER;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.NONE);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!EnricherConfig.modInfoEnabled) {
            return null;
        }
        TooltipLines components = new TooltipLines();
        TooltipTarget target = context.getTarget();
        GameRegistry.UniqueIdentifier identifier = UNKNOWN_IDENTIFIER;
        if (target.isItem()) {
            identifier = ModInfoEnricher.getIdentifier(target.getItem());
        } else if (target.isFluid()) {
            identifier = new GameRegistry.UniqueIdentifier(FluidRegistry.getDefaultFluidName((Fluid)target.getFluid().getFluid()));
        } else {
            return null;
        }
        ModInfoEnricherEvent event = new ModInfoEnricherEvent(target, ModInfoEnricher.nameFromIdentifier(identifier), identifier.modId, identifier.name);
        TooltipUtils.postEvent(event);
        if (TooltipUtils.isCtrlKeyDown() && TooltipUtils.mc().field_71474_y.field_82882_x) {
            components.line(TooltipUtils.translate("enricher.modinfo.identifier", event.modId, event.itemId));
        } else {
            components.line(TooltipUtils.translate("enricher.modinfo.modname", event.modName));
        }
        return components;
    }

    protected static GameRegistry.UniqueIdentifier getIdentifier(ItemStack stack) {
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        return identifier != null ? identifier : UNKNOWN_IDENTIFIER;
    }

    protected static String nameFromIdentifier(GameRegistry.UniqueIdentifier identifier) {
        ModContainer modContainer;
        if (namedMods == null) {
            namedMods = Loader.instance().getIndexedModList();
        }
        return (modContainer = namedMods.get(identifier.modId)) != null ? modContainer.getName() : DEFAULT_MOD_NAME;
    }
}

