/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryEnricher
implements ITooltipEnricher {
    protected String titleComponent = TooltipUtils.translate("enricher.oreDictionary.title", new Object[0]);

    @Override
    public String sectionId() {
        return "oreDictionary";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.CTRL);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        ItemStack stack = context.getItem();
        if (stack == null || !EnricherConfig.oreDictionaryEnabled) {
            return null;
        }
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (int oredict : OreDictionary.getOreIDs((ItemStack)stack)) {
            components.add(new TextComponent(TooltipUtils.translate("enricher.oreDictionary.entry", OreDictionary.getOreName((int)oredict))));
        }
        if (!components.isEmpty()) {
            components.add(0, new TextComponent(this.titleComponent));
        }
        return new TooltipLines(components);
    }
}

