/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.config.StackAmountConfig;
import com.slprime.chromatictooltips.event.StackSizeEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.awt.Point;
import java.util.EnumSet;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class StackSizeEnricher
implements ITooltipEnricher {
    @Override
    public String sectionId() {
        return "stacksize";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.SHIFT);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!EnricherConfig.stackAmountEnabled) {
            return null;
        }
        TooltipTarget target = context.getTarget();
        if (!target.isItem() && !target.isFluid()) {
            return null;
        }
        long stackAmount = target.getStackAmount();
        if (StackAmountConfig.includeContainerInventory && target.isItem()) {
            stackAmount = this.getStackSize(target.getItem());
        }
        StackSizeEnricherEvent event = new StackSizeEnricherEvent(target, stackAmount);
        TooltipUtils.postEvent(event);
        if (event.stackAmount <= 0L) {
            return null;
        }
        TooltipLines components = new TooltipLines();
        if (target.isItem() && event.stackAmount > 1L && (!StackAmountConfig.hideWhenBelowMaxStackSize || event.stackAmount > (long)target.getItem().func_77976_d() || event.stackAmount != target.getStackAmount())) {
            components.line(this.formatItemAmount(event.stackAmount, target.getItem().func_77976_d()));
        }
        if (target.isFluidContainer() && target.getContainedFluidAmount() > 0L) {
            components.line(this.formatFluidAmount(event.stackAmount * target.getContainedFluidAmount()));
        }
        if (target.isFluid() && (!StackAmountConfig.hideWhenBelowMaxStackSize || event.stackAmount > 144L)) {
            components.line(this.formatFluidAmount(event.stackAmount));
        }
        return components;
    }

    protected long getStackSize(ItemStack stack) {
        GuiContainer guiContainer = TooltipUtils.getGuiContainer();
        if (guiContainer != null) {
            Point mouse = TooltipUtils.getMousePosition();
            Slot slot = guiContainer.func_146975_c(mouse.x, mouse.y);
            if (slot != null && slot.func_75216_d()) {
                long stackSize = 0L;
                for (Slot currentSlot : guiContainer.field_147002_h.field_75151_b) {
                    if (slot.field_75224_c != currentSlot.field_75224_c || !currentSlot.func_75216_d() || !stack.func_77969_a(currentSlot.func_75211_c()) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentSlot.func_75211_c())) continue;
                    stackSize += (long)currentSlot.func_75211_c().field_77994_a;
                }
                return stackSize == 0L ? (long)stack.field_77994_a : stackSize;
            }
        }
        return stack.field_77994_a;
    }

    protected String formatItemAmount(long stackAmount, int maxStackSize) {
        return this.format(stackAmount, maxStackSize, "enricher.stacksize.item", StackAmountConfig.itemConfig);
    }

    protected String formatFluidAmount(long stackAmount) {
        return this.format(stackAmount, 144L, "enricher.stacksize.fluid", StackAmountConfig.fluidConfig);
    }

    protected String format(long stackAmount, long maxStackSize, String pattern, StackAmountConfig.FormatConfig formatter) {
        if (stackAmount <= maxStackSize || maxStackSize == 1L) {
            return TooltipUtils.translate(pattern, formatter.numberFormat.format(stackAmount, formatter.detailCutoffPower));
        }
        long remainder = stackAmount % maxStackSize;
        if (remainder > 0L) {
            return TooltipUtils.translate(pattern + ".full", formatter.numberFormat.format(stackAmount, formatter.detailCutoffPower), formatter.numberFormat.format(stackAmount / maxStackSize, formatter.detailCutoffPower), formatter.numberFormat.format(maxStackSize, formatter.detailCutoffPower), formatter.numberFormat.format(remainder, formatter.detailCutoffPower));
        }
        return TooltipUtils.translate(pattern + ".short", formatter.numberFormat.format(stackAmount, formatter.detailCutoffPower), formatter.numberFormat.format(stackAmount / maxStackSize, formatter.detailCutoffPower), formatter.numberFormat.format(maxStackSize, formatter.detailCutoffPower));
    }
}

