/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.event.TitleEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipUtils;
import cpw.mods.fml.common.registry.GameData;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class TitleEnricher
implements ITooltipEnricher {
    @Override
    public String sectionId() {
        return "title";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.HEADER;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.NONE);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (context.getItem() != null) {
            return this.itemTitle(context.getTarget());
        }
        if (context.getFluid() != null) {
            return this.fluidTitle(context.getTarget());
        }
        return this.defaultTitle(context);
    }

    protected TooltipLines defaultTitle(TooltipContext context) {
        List<ITooltipComponent> lines = context.getContextTooltip();
        if (lines.isEmpty()) {
            return null;
        }
        ITooltipComponent iTooltipComponent = lines.get(0);
        if (iTooltipComponent instanceof TextComponent) {
            TextComponent title = (TextComponent)iTooltipComponent;
            String line = title.getLines().get(0);
            if (TooltipUtils.getColorCodeIndex(line) == TooltipLines.BASE_COLOR.ordinal()) {
                line = EnumChatFormatting.WHITE + line.replaceAll("^(?:\u00a7[0-9a-fk-or])+", "");
            }
            return new TooltipLines(line);
        }
        return new TooltipLines(lines.get(0));
    }

    protected TooltipLines fluidTitle(TooltipTarget target) {
        FluidStack fluid = target.getFluid();
        String displayName = fluid.getFluid().getLocalizedName(fluid);
        TextComponent identifierComponent = new TextComponent(EnumChatFormatting.DARK_GRAY + this.getAdvancedInfo(fluid));
        TitleEnricherEvent event = new TitleEnricherEvent(target, displayName);
        TooltipUtils.postEvent(event);
        return new TooltipLines(new StackTitleTooltipComponent(EnumChatFormatting.AQUA + event.displayName, identifierComponent));
    }

    protected TooltipLines itemTitle(TooltipTarget target) {
        ItemStack stack = target.getItem();
        TextComponent identifierComponent = new TextComponent(EnumChatFormatting.DARK_GRAY + this.getAdvancedInfo(stack));
        TitleEnricherEvent event = new TitleEnricherEvent(target, stack.func_82833_r());
        TooltipUtils.postEvent(event);
        return new TooltipLines(new StackTitleTooltipComponent(this.prepareItemDisplayName(stack, event.displayName), identifierComponent));
    }

    private String prepareItemDisplayName(ItemStack stack, String displayName) {
        String rarityColor = stack.func_77953_t().field_77937_e.toString();
        if (stack.func_82837_s()) {
            return rarityColor + EnumChatFormatting.ITALIC + displayName;
        }
        return rarityColor + displayName;
    }

    private String getAdvancedInfo(ItemStack stack) {
        if (TooltipUtils.mc().field_71474_y.field_82882_x) {
            int itemId = Item.func_150891_b((Item)stack.func_77973_b());
            if (stack.func_77981_g()) {
                return String.format(" #%04d/%d", itemId, stack.func_77960_j());
            }
            return String.format(" #%04d", itemId);
        }
        if (!stack.func_82837_s() && stack.func_77973_b() == Items.field_151098_aY) {
            return " #" + stack.func_77960_j();
        }
        return "";
    }

    private String getAdvancedInfo(FluidStack fluidStack) {
        if (TooltipUtils.mc().field_71474_y.field_82882_x) {
            int fluidId = GameData.getBlockRegistry().getId((Object)fluidStack.getFluid().getBlock());
            if (fluidId == -1) {
                return "";
            }
            return String.format(" #%04d", fluidId);
        }
        return "";
    }

    protected static class StackTitleTooltipComponent
    extends TextComponent {
        protected ITooltipComponent identifierComponent;

        public StackTitleTooltipComponent(String title, ITooltipComponent identifierComponent) {
            super(title);
            this.identifierComponent = identifierComponent;
        }

        @Override
        public int getWidth() {
            int width = super.getWidth();
            if (this.identifierComponent.getWidth() > 0) {
                width += TooltipFontContext.getStringWidth(" ") + this.identifierComponent.getWidth();
            }
            return width;
        }

        @Override
        public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
            return new ITooltipComponent[]{this};
        }

        @Override
        public void draw(int x, int y, int availableWidth, TooltipContext context) {
            int identifierWidth = this.identifierComponent.getWidth();
            super.draw(x, y, availableWidth, context);
            this.identifierComponent.draw(x + availableWidth - identifierWidth, y, identifierWidth, context);
        }
    }
}

