/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.slprime.chromatictooltips.api.TooltipTarget;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackFilterParser {
    protected static final Map<String, Function<String, Predicate<TooltipTarget>>> customFilters = new HashMap<String, Function<String, Predicate<TooltipTarget>>>();

    private ItemStackFilterParser() {
    }

    public static Predicate<TooltipTarget> parse(String filterText) {
        Predicate<TooltipTarget> filter = target -> false;
        boolean hasFilters = false;
        if (!(filterText = filterText.trim()).isEmpty()) {
            for (String part : filterText.split("\\s*\\|\\s*")) {
                Predicate<TooltipTarget> ruleFilter = ItemStackFilterParser.parsePart(part);
                if (ruleFilter == null) continue;
                filter = filter.or(ruleFilter);
                hasFilters = true;
            }
        }
        return hasFilters ? filter : null;
    }

    public static void registerCustomFilter(String name, Function<String, Predicate<TooltipTarget>> filterFunction) {
        customFilters.put(name, filterFunction);
    }

    private static Predicate<TooltipTarget> parsePart(String part) {
        Predicate<TooltipTarget> partFilter = target -> true;
        boolean hasFilters = false;
        for (String token : part.split("\\s+")) {
            Predicate<TooltipTarget> ruleFilter = ItemStackFilterParser.parseRules(token);
            if (ruleFilter == null) continue;
            partFilter = partFilter.and(ruleFilter);
            hasFilters = true;
        }
        return hasFilters ? new SafePredicate<TooltipTarget>(partFilter) : null;
    }

    protected static Predicate<TooltipTarget> parseRules(String token) {
        Predicate<TooltipTarget> orFilter = target -> false;
        Predicate<TooltipTarget> orNotFilter = target -> false;
        Predicate<TooltipTarget> ruleFilter = target -> true;
        boolean hasFilters = false;
        boolean hasNotFilters = false;
        for (String rule : token.split(",")) {
            boolean ignore = rule.startsWith("!");
            Predicate<TooltipTarget> filter = null;
            if (ignore) {
                rule = rule.substring(1);
            }
            if (rule.startsWith("$")) {
                filter = ItemStackFilterParser.getOreDictFilter(rule.substring(1));
            } else if (rule.startsWith("tag.")) {
                filter = ItemStackFilterParser.getTagFilter(rule.substring(4));
            } else if (rule.startsWith("rarity:")) {
                filter = ItemStackFilterParser.getRarityFilter(rule.substring(7));
            } else if (Pattern.matches("^\\d+(-\\d+)?$", rule)) {
                filter = ItemStackFilterParser.getDamageFilter(rule);
            } else {
                String[] parts;
                Function<String, Predicate<TooltipTarget>> customFilter;
                if (rule.contains(":") && (customFilter = customFilters.get((parts = rule.split(":", 2))[0])) != null) {
                    filter = customFilter.apply(parts[1]);
                }
                if (filter == null) {
                    filter = ItemStackFilterParser.getStringIdentifierFilter(rule);
                }
            }
            if (filter == null) continue;
            if (ignore) {
                orNotFilter = orNotFilter.or(filter);
                hasNotFilters = true;
                continue;
            }
            orFilter = orFilter.or(filter);
            hasFilters = true;
        }
        if (hasFilters) {
            ruleFilter = ruleFilter.and(orFilter);
        }
        if (hasNotFilters) {
            ruleFilter = ruleFilter.and(orNotFilter.negate());
        }
        return hasFilters || hasNotFilters ? ruleFilter : null;
    }

    protected static Predicate<String> getMatcher(String searchText) {
        if (searchText.length() >= 3 && searchText.startsWith("r/") && searchText.endsWith("/")) {
            try {
                Pattern pattern = Pattern.compile(searchText.substring(2, searchText.length() - 1), 74);
                return value -> pattern.matcher((CharSequence)value).find();
            }
            catch (PatternSyntaxException pattern) {}
        } else if (!searchText.isEmpty()) {
            String lowerCase = searchText.toLowerCase();
            return value -> value.toLowerCase().contains(lowerCase);
        }
        return null;
    }

    protected static Predicate<TooltipTarget> getOreDictFilter(String rule) {
        Predicate<String> matcher = ItemStackFilterParser.getMatcher(rule);
        if (matcher == null) {
            return null;
        }
        return target -> target.isItem() && IntStream.of(OreDictionary.getOreIDs((ItemStack)target.getItem())).anyMatch(id -> matcher.test(OreDictionary.getOreName((int)id)));
    }

    protected static Predicate<TooltipTarget> getTagFilter(String rule) {
        String[] parts = rule.split("=", 2);
        String[] path = parts[0].split("\\.");
        Predicate<String> value = ItemStackFilterParser.getMatcher(parts[1]);
        return target -> {
            if (!target.isItem()) {
                return false;
            }
            Object tag = target.getItem().func_77978_p();
            for (int i = 0; i < path.length && tag != null; ++i) {
                if (tag instanceof NBTTagCompound) {
                    NBTTagCompound compound = tag;
                    tag = compound.func_74781_a(path[i]);
                    continue;
                }
                if (tag instanceof NBTTagList) {
                    NBTTagList list = (NBTTagList)tag;
                    tag = list.field_74747_a.get(Integer.parseInt(path[i]));
                    continue;
                }
                tag = null;
            }
            return tag == null ? value == null : value != null && value.test(tag.toString());
        };
    }

    protected static Predicate<TooltipTarget> getRarityFilter(String rule) {
        Predicate<String> matcher = ItemStackFilterParser.getMatcher(rule);
        if (matcher == null) {
            return null;
        }
        return target -> target.isItem() && matcher.test(target.getItem().func_77953_t().field_77934_f);
    }

    protected static Predicate<TooltipTarget> getDamageFilter(String rule) {
        IntPredicate matcher;
        String[] range = rule.split("-");
        if (range.length == 1) {
            int damage = Integer.parseInt(range[0]);
            matcher = dmg -> dmg == damage;
        } else {
            int damageStart = Integer.parseInt(range[0]);
            int damageEnd = Integer.parseInt(range[1]);
            matcher = dmg -> dmg >= damageStart && dmg <= damageEnd;
        }
        return target -> target.isItem() && matcher.test(target.getItem().func_77960_j());
    }

    protected static Predicate<TooltipTarget> getStringIdentifierFilter(String rule) {
        FMLControlledNamespacedRegistry iItemRegistry = GameData.getItemRegistry();
        Predicate<String> matcher = ItemStackFilterParser.getMatcher(rule);
        if (matcher == null) {
            return null;
        }
        return target -> {
            String name = null;
            if (target.isItem()) {
                name = iItemRegistry.func_148750_c((Object)target.getItem());
            } else if (target.isFluid()) {
                name = FluidRegistry.getDefaultFluidName((Fluid)target.getFluid().getFluid());
            } else {
                return false;
            }
            return name != null && !name.isEmpty() && matcher.test(name);
        };
    }

    protected static class SafePredicate<T>
    implements Predicate<T> {
        private final Predicate<T> predicate;

        public SafePredicate(Predicate<T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(T t) {
            try {
                return this.predicate.test(t);
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

