/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.util.TooltipAlign;
import com.slprime.chromatictooltips.util.TooltipRenderUtils;
import com.slprime.chromatictooltips.util.TooltipSpacing;
import com.slprime.chromatictooltips.util.TooltipTexture;
import com.slprime.chromatictooltips.util.TooltipTransform;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TooltipDecorator {
    public static final int TRANSPARENT = 0;
    public static final int WHITE = -1;
    protected TooltipTexture texture = null;
    protected TooltipTransform transform = null;
    protected DecoratorType decoratorType = DecoratorType.NONE;
    protected int[] colors = null;
    protected int thickness = 1;
    protected boolean corner = true;
    protected TooltipSpacing margin;
    protected TooltipAlign alignInline = TooltipAlign.START;
    protected TooltipAlign alignBlock = TooltipAlign.END;
    protected int sizeWidth = 0;
    protected int sizeHeight = 0;

    public TooltipDecorator(TooltipStyle style) {
        this.decoratorType = DecoratorType.fromString(style.getAsString("type", "none"));
        this.margin = style.getAsTooltipSpacing("margin", new int[]{0, 0, 0, 0});
        this.alignInline = TooltipAlign.fromString(style.getAsString("alignInline", style.getAsString("align.inline", "left")));
        this.alignBlock = TooltipAlign.fromString(style.getAsString("alignBlock", style.getAsString("align.block", "top")));
        this.sizeWidth = style.getAsInt("width", 0);
        this.sizeHeight = style.getAsInt("height", 0);
        if (this.decoratorType == DecoratorType.TEXTURE && style.containsKey("path")) {
            this.texture = new TooltipTexture(style);
        } else if (this.decoratorType == DecoratorType.BACKGROUND || this.decoratorType == DecoratorType.BORDER) {
            this.colors = style.get("color") != null && style.get("color").isJsonArray() ? this.prepare4Colors(style.getAsColors("color", new int[]{0})) : this.prepare4Colors(new int[]{style.getAsColor("color", 0)});
            this.thickness = style.getAsInt("thickness", 1);
            this.corner = style.getAsBoolean("corner", true);
        } else if (this.decoratorType == DecoratorType.VERTICAL || this.decoratorType == DecoratorType.HORIZONTAL) {
            if (style.get("color") != null && style.get("color").isJsonArray()) {
                this.colors = style.getAsColors("color", new int[]{0});
            } else {
                int colorInt = style.getAsColor("color", 0);
                int color60Int = colorInt & 0xFFFFFF | (colorInt >> 24 & 0xFF) * 96 / 255 << 24;
                this.colors = new int[]{0, color60Int, colorInt, color60Int, 0};
            }
        } else {
            this.colors = new int[0];
        }
        if (this.decoratorType != DecoratorType.TEXTURE && this.decoratorType != DecoratorType.ITEM && this.colors.length == 0) {
            this.decoratorType = DecoratorType.NONE;
        }
        if (this.decoratorType != DecoratorType.NONE && style.containsKey("transform")) {
            this.transform = new TooltipTransform(style.getAsStyle("transform"));
        }
    }

    protected int[] prepare4Colors(int[] colors) {
        if (colors.length == 1) {
            return new int[]{colors[0], colors[0], colors[0], colors[0]};
        }
        if (colors.length == 2) {
            return new int[]{colors[0], colors[0], colors[1], colors[1]};
        }
        if (colors.length == 3) {
            return new int[]{colors[0], colors[1], colors[2], colors[0]};
        }
        return colors;
    }

    public void draw(double x, double y, int w, int h, TooltipContext context, int mixColor) {
        double height;
        x += (double)this.margin.left;
        y += (double)this.margin.top;
        double width = this.sizeWidth == 0 ? (double)(w -= this.margin.left + this.margin.right) : (double)this.sizeWidth;
        double d = height = this.sizeHeight == 0 ? (double)(h -= this.margin.top + this.margin.bottom) : (double)this.sizeHeight;
        if (this.texture != null) {
            width = this.sizeWidth == 0 ? this.texture.getWidth(width) : width;
            double d2 = height = this.sizeHeight == 0 ? this.texture.getHeight(height) : height;
        }
        if (width == 0.0 || height == 0.0) {
            return;
        }
        if (this.alignInline == TooltipAlign.END) {
            x += (double)w - width;
        } else if (this.alignInline == TooltipAlign.CENTER) {
            x += ((double)w - width) / 2.0;
        }
        if (this.alignBlock == TooltipAlign.END) {
            y += (double)h - height;
        } else if (this.alignBlock == TooltipAlign.CENTER) {
            y += ((double)h - height) / 2.0;
        }
        if (this.transform != null && this.transform.isAnimated()) {
            this.transform.pushTransformMatrix(x, y, width, height, context.getAnimationStartTime());
            y = 0.0;
            x = 0.0;
        }
        if (this.texture != null) {
            this.texture.draw(x, y, width, height, this.alignInline, this.alignBlock, mixColor);
        } else if (this.decoratorType == DecoratorType.ITEM) {
            ItemStack stack = context.getItem();
            FluidStack fluid = context.getFluid();
            if (stack != null) {
                this.drawItemContext(x, y, width, height, () -> TooltipRenderUtils.drawItemStack(stack, 0L, false));
            } else if (fluid != null) {
                this.drawItemContext(x, y, width, height, () -> TooltipRenderUtils.drawFluidStack(fluid, 0L));
            }
        } else if (this.decoratorType != DecoratorType.NONE) {
            this.drawGradient(x, y, width, height, mixColor);
        }
        if (this.transform != null && this.transform.isAnimated()) {
            this.transform.popTransformMatrix();
        }
    }

    protected void drawItemContext(double x, double y, double width, double height, Runnable callback) {
        double scale = Math.min(width / 16.0, height / 16.0);
        GL11.glTranslated((double)x, (double)y, (double)400.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        callback.run();
        GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)(1.0 / scale));
        GL11.glTranslated((double)(-x), (double)(-y), (double)-400.0);
    }

    protected void drawGradient(double x, double y, double width, double height, int mixColor) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glShadeModel((int)7425);
        if (this.decoratorType == DecoratorType.HORIZONTAL) {
            double segmentWidth = width / (double)(this.colors.length - 1);
            for (int i = 0; i < this.colors.length - 1; ++i) {
                this.drawGradientRect(x, y, x + segmentWidth, y + height, TooltipDecorator.blend(this.colors[i], mixColor), TooltipDecorator.blend(this.colors[i], mixColor), TooltipDecorator.blend(this.colors[i + 1], mixColor), TooltipDecorator.blend(this.colors[i + 1], mixColor));
                x += segmentWidth;
            }
        } else if (this.decoratorType == DecoratorType.VERTICAL) {
            double segmentHeight = height / (double)(this.colors.length - 1);
            for (int i = 0; i < this.colors.length - 1; ++i) {
                this.drawGradientRect(x, y, x + width, y + segmentHeight, TooltipDecorator.blend(this.colors[i], mixColor), TooltipDecorator.blend(this.colors[i + 1], mixColor), TooltipDecorator.blend(this.colors[i], mixColor), TooltipDecorator.blend(this.colors[i + 1], mixColor));
                y += segmentHeight;
            }
        } else if (this.decoratorType == DecoratorType.BACKGROUND) {
            int offset = this.corner ? 0 : this.thickness;
            this.drawGradientRect(x + (double)offset, y + (double)offset, x + width - (double)offset, y + height - (double)offset, TooltipDecorator.blend(this.colors[0], mixColor), TooltipDecorator.blend(this.colors[1], mixColor), TooltipDecorator.blend(this.colors[3], mixColor), TooltipDecorator.blend(this.colors[2], mixColor));
            if (!this.corner) {
                this.drawBorder(x, y, width, height, this.thickness, mixColor);
            }
        } else if (this.decoratorType == DecoratorType.BORDER) {
            this.drawBorder(x, y, width, height, this.corner ? 0 : this.thickness, mixColor);
        }
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    protected void drawBorder(double x, double y, double width, double height, int offset, int mixColor) {
        int[] colors = new int[]{TooltipDecorator.blend(this.colors[0], mixColor), TooltipDecorator.blend(this.colors[1], mixColor), TooltipDecorator.blend(this.colors[2], mixColor), TooltipDecorator.blend(this.colors[3], mixColor)};
        this.drawGradientRect(x + (double)offset, y, x + width - (double)offset, y + (double)this.thickness, colors[0], colors[0], colors[1], colors[1]);
        this.drawGradientRect(x + (double)offset, y + height - (double)this.thickness, x + width - (double)offset, y + height, colors[3], colors[3], colors[2], colors[2]);
        this.drawGradientRect(x, y + (double)this.thickness, x + (double)this.thickness, y + height - (double)this.thickness, colors[0], colors[3], colors[0], colors[3]);
        this.drawGradientRect(x + width - (double)this.thickness, y + (double)this.thickness, x + width, y + height - (double)this.thickness, colors[1], colors[2], colors[1], colors[2]);
    }

    protected void drawGradientRect(double left, double top, double right, double bottom, int lt, int lb, int rt, int rb) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78384_a(lt, lt >> 24 & 0xFF);
        tess.func_78377_a(left, top, 0.0);
        tess.func_78384_a(lb, lb >> 24 & 0xFF);
        tess.func_78377_a(left, bottom, 0.0);
        tess.func_78384_a(rb, rb >> 24 & 0xFF);
        tess.func_78377_a(right, bottom, 0.0);
        tess.func_78384_a(rt, rt >> 24 & 0xFF);
        tess.func_78377_a(right, top, 0.0);
        tess.func_78381_a();
    }

    public static int blend(int dst, int src) {
        int tr = dst >>> 16 & 0xFF;
        int tg = dst >>> 8 & 0xFF;
        int tb = dst & 0xFF;
        int ta = dst >>> 24 & 0xFF;
        int cr = src >>> 16 & 0xFF;
        int cg = src >>> 8 & 0xFF;
        int cb = src & 0xFF;
        int r = tr * cr / 255;
        int g = tg * cg / 255;
        int b = tb * cb / 255;
        return ta << 24 | r << 16 | g << 8 | b;
    }

    protected static enum DecoratorType {
        NONE,
        BACKGROUND,
        TEXTURE,
        ITEM,
        BORDER,
        HORIZONTAL,
        VERTICAL;


        public static DecoratorType fromString(String str) {
            switch (str.toLowerCase()) {
                case "gradient-horizontal": {
                    return HORIZONTAL;
                }
                case "gradient-vertical": {
                    return VERTICAL;
                }
                case "background": {
                    return BACKGROUND;
                }
                case "texture": {
                    return TEXTURE;
                }
                case "border": {
                    return BORDER;
                }
                case "item": {
                    return ITEM;
                }
            }
            return NONE;
        }
    }
}

