/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class TooltipFontContext {
    public static final int LINE_SPACE = 1;
    public static final int DEFAULT_SPACING = 2;
    protected static FontRenderer fontRenderer = null;
    protected static final int INHERIT_COLOR = 0;
    protected static final String[] colorOrders = new String[]{"black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow", "white"};
    protected Context previousContext = null;
    protected static Context activeContext = null;
    protected int[] customColors = new int[32];
    protected Boolean shadow = null;
    protected Integer paragraph = null;

    public TooltipFontContext(TooltipStyle formatting) {
        TooltipStyle colorStyle = new TooltipStyle(formatting.getAsJsonObject("font.colors", formatting.getAsJsonObject("fontColors", new JsonObject())));
        if (formatting.containsKey("font.shadow")) {
            this.shadow = formatting.getAsBoolean("font.shadow", true);
        } else if (formatting.containsKey("fontShadow")) {
            this.shadow = formatting.getAsBoolean("fontShadow", true);
        }
        if (formatting.containsKey("font.paragraph")) {
            this.paragraph = formatting.getAsInt("font.paragraph", 6);
        } else if (formatting.containsKey("fontParagraph")) {
            this.paragraph = formatting.getAsInt("fontParagraph", 6);
        }
        Arrays.fill(this.customColors, 0);
        for (int i = 0; i < colorOrders.length; ++i) {
            int color;
            String key = colorOrders[i];
            if (!colorStyle.containsKey(key)) continue;
            JsonElement element = colorStyle.get(key);
            if (element.isJsonArray()) {
                int color2;
                int[] colors = colorStyle.getAsColors(key, new int[]{0});
                this.customColors[i] = color2 = colors[0] & 0xFFFFFF;
                if (colors.length == 1) {
                    this.customColors[i + 16] = (color2 & 0xFCFCFC) >> 2 | color2 & 0xFF000000;
                    continue;
                }
                this.customColors[i + 16] = colors[1] & 0xFFFFFF;
                continue;
            }
            if (!element.isJsonPrimitive()) continue;
            this.customColors[i] = color = colorStyle.getAsColor(key, 0) & 0xFFFFFF;
            this.customColors[i + 16] = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
    }

    protected static Context context() {
        if (activeContext == null) {
            activeContext = new Context(new int[0], true, 6);
        }
        return activeContext;
    }

    public void pushContext() {
        this.previousContext = TooltipFontContext.context();
        activeContext = new Context(this.customColors, this.shadow == null ? TooltipFontContext.activeContext.shadow : this.shadow, this.paragraph == null ? TooltipFontContext.activeContext.paragraph : this.paragraph);
        activeContext.applyColors();
    }

    public void popContext() {
        activeContext = this.previousContext;
        activeContext.applyColors();
    }

    public static int getColor(int index) {
        return TooltipFontContext.context().colors[index];
    }

    public static int getColorShadow(int index) {
        return TooltipFontContext.context().colors[index + 16];
    }

    public static int getParagraphSpacing() {
        return TooltipFontContext.context().paragraph;
    }

    public static FontRenderer getFontRenderer() {
        if (fontRenderer == null) {
            fontRenderer = TooltipUtils.mc().field_71466_p;
        }
        return fontRenderer;
    }

    public static int getFontHeight() {
        return TooltipFontContext.getFontRenderer().field_78288_b + 1;
    }

    public static int getStringWidth(String text) {
        return TooltipFontContext.getFontRenderer().func_78256_a(text);
    }

    public static List<String> listFormattedStringToWidth(String text, int maxWidth) {
        return TooltipFontContext.getFontRenderer().func_78271_c(text, maxWidth);
    }

    public static void drawString(String text, int x, int y) {
        TooltipFontContext.drawString(text, x, y, -1, TooltipFontContext.context().shadow);
    }

    public static void drawString(String text, int x, int y, int color) {
        TooltipFontContext.drawString(text, x, y, color, TooltipFontContext.context().shadow);
    }

    public static void drawString(String text, int x, int y, int color, boolean shadow) {
        TooltipFontContext.getFontRenderer().func_85187_a(text, x, y, color, shadow);
    }

    protected static class Context {
        public int[] colors = new int[32];
        public boolean shadow = true;
        public int paragraph = 6;

        public Context(int[] colors, boolean shadow, int paragraph) {
            this.colors = Arrays.copyOf(TooltipFontContext.getFontRenderer().field_78285_g, 32);
            this.shadow = shadow;
            this.paragraph = paragraph;
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] == 0) continue;
                this.colors[i] = colors[i];
            }
        }

        public void applyColors() {
            System.arraycopy(this.colors, 0, TooltipFontContext.getFontRenderer().field_78285_g, 0, 32);
        }
    }
}

